/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.messaging;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sns.message.SnsMessageManager;
import io.awspring.cloud.autoconfigure.messaging.SnsProperties;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.region.RegionProvider;
import io.awspring.cloud.core.region.StaticRegionProvider;
import io.awspring.cloud.messaging.endpoint.config.NotificationHandlerMethodArgumentResolverConfigurationUtils;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AmazonSNS.class})
@EnableConfigurationProperties(value={SnsProperties.class})
@ConditionalOnProperty(name={"cloud.aws.sns.enabled"}, havingValue="true", matchIfMissing=true)
public class SnsAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SnsAutoConfiguration.class);
    private final AWSCredentialsProvider awsCredentialsProvider;
    private final RegionProvider regionProvider;
    private final ClientConfiguration clientConfiguration;

    SnsAutoConfiguration(ObjectProvider<AWSCredentialsProvider> awsCredentialsProvider, ObjectProvider<RegionProvider> regionProvider, SnsProperties properties, @Qualifier(value="com.amazonaws.ClientConfiguration.BEAN_NAME") ObjectProvider<ClientConfiguration> globalClientConfiguration, @Qualifier(value="snsClientConfiguration") ObjectProvider<ClientConfiguration> snsClientConfiguration) {
        this.awsCredentialsProvider = (AWSCredentialsProvider)awsCredentialsProvider.getIfAvailable();
        this.regionProvider = properties.getRegion() == null ? (RegionProvider)regionProvider.getIfAvailable() : new StaticRegionProvider(properties.getRegion());
        this.clientConfiguration = (ClientConfiguration)snsClientConfiguration.getIfAvailable(() -> globalClientConfiguration.getIfAvailable());
    }

    @ConditionalOnMissingAmazonClient(value=AmazonSNS.class)
    @Bean
    public AmazonWebserviceClientFactoryBean<AmazonSNSClient> amazonSNS(SnsProperties properties) {
        AmazonWebserviceClientFactoryBean clientFactoryBean = new AmazonWebserviceClientFactoryBean(AmazonSNSClient.class, this.awsCredentialsProvider, this.regionProvider, this.clientConfiguration);
        Optional.ofNullable(properties.getEndpoint()).ifPresent(arg_0 -> ((AmazonWebserviceClientFactoryBean)clientFactoryBean).setCustomEndpoint(arg_0));
        return clientFactoryBean;
    }

    @ConditionalOnProperty(name={"cloud.aws.sns.verification"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={SnsMessageManager.class})
    @Bean
    public SnsMessageManager snsMessageManager(SnsProperties snsProperties) {
        if (this.regionProvider == null) {
            String defaultRegion = Regions.DEFAULT_REGION.getName();
            LOGGER.warn("RegionProvider bean not configured. Configuring SnsMessageManager with region " + defaultRegion);
            return new SnsMessageManager(defaultRegion);
        }
        return new SnsMessageManager(this.regionProvider.getRegion().getName());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={WebMvcConfigurer.class})
    static class SnsWebConfiguration {
        SnsWebConfiguration() {
        }

        @Bean
        public WebMvcConfigurer snsWebMvcConfigurer(final AmazonSNS amazonSns, final Optional<SnsMessageManager> snsMessageManager) {
            return new WebMvcConfigurer(){

                public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
                    resolvers.add(NotificationHandlerMethodArgumentResolverConfigurationUtils.getNotificationHandlerMethodArgumentResolver((AmazonSNS)amazonSns, (Optional)snsMessageManager));
                }
            };
        }
    }
}

