/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.security;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.cloud.aws.security.cognito")
public class CognitoAuthenticationProperties {
    private static final String COGNITO_ISSUER = "https://cognito-idp.%s.amazonaws.com/%s";
    private static final String COGNITO_REGISTRY = "https://cognito-idp.%s.amazonaws.com/%s/.well-known/jwks.json";
    private String userPoolId;
    private String region;
    private String algorithm = "RS256";
    private String appClientId;

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegistry() {
        return String.format(COGNITO_REGISTRY, this.region, this.userPoolId);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getIssuer() {
        return String.format(COGNITO_ISSUER, this.region, this.userPoolId);
    }

    public String getAppClientId() {
        return this.appClientId;
    }

    public void setAppClientId(String appClientId) {
        this.appClientId = appClientId;
    }
}

