/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.metrics;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClient;
import io.awspring.cloud.autoconfigure.context.ContextCredentialsAutoConfiguration;
import io.awspring.cloud.autoconfigure.metrics.CloudWatchProperties;
import io.awspring.cloud.autoconfigure.metrics.CloudWatchPropertiesConfigAdapter;
import io.awspring.cloud.context.annotation.ConditionalOnMissingAmazonClient;
import io.awspring.cloud.core.config.AmazonWebserviceClientFactoryBean;
import io.awspring.cloud.core.region.RegionProvider;
import io.awspring.cloud.core.region.StaticRegionProvider;
import io.micrometer.cloudwatch.CloudWatchConfig;
import io.micrometer.cloudwatch.CloudWatchMeterRegistry;
import io.micrometer.core.instrument.Clock;
import java.util.Optional;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@Import(value={ContextCredentialsAutoConfiguration.class})
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@EnableConfigurationProperties(value={CloudWatchProperties.class})
@ConditionalOnProperty(prefix="management.metrics.export.cloudwatch", name={"namespace"})
@ConditionalOnClass(value={CloudWatchMeterRegistry.class, RegionProvider.class})
public class CloudWatchExportAutoConfiguration {
    private final AWSCredentialsProvider credentialsProvider;
    private final RegionProvider regionProvider;
    private final ClientConfiguration clientConfiguration;

    public CloudWatchExportAutoConfiguration(AWSCredentialsProvider credentialsProvider, ObjectProvider<RegionProvider> regionProvider, CloudWatchProperties properties, @Qualifier(value="com.amazonaws.ClientConfiguration.BEAN_NAME") ObjectProvider<ClientConfiguration> globalClientConfiguration, @Qualifier(value="cloudWatchClientConfiguration") ObjectProvider<ClientConfiguration> cloudWatchClientConfiguration) {
        this.credentialsProvider = credentialsProvider;
        this.regionProvider = properties.getRegion() == null ? (RegionProvider)regionProvider.getIfAvailable() : new StaticRegionProvider(properties.getRegion());
        this.clientConfiguration = (ClientConfiguration)cloudWatchClientConfiguration.getIfAvailable(() -> globalClientConfiguration.getIfAvailable());
    }

    @Bean
    @ConditionalOnProperty(value={"management.metrics.export.cloudwatch.enabled"}, matchIfMissing=true)
    public CloudWatchMeterRegistry cloudWatchMeterRegistry(CloudWatchConfig config, Clock clock, AmazonCloudWatchAsync client) {
        return new CloudWatchMeterRegistry(config, clock, client);
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonCloudWatchAsync.class)
    public AmazonWebserviceClientFactoryBean<AmazonCloudWatchAsyncClient> amazonCloudWatchAsync(CloudWatchProperties properties) {
        AmazonWebserviceClientFactoryBean clientFactoryBean = new AmazonWebserviceClientFactoryBean(AmazonCloudWatchAsyncClient.class, this.credentialsProvider, this.regionProvider, this.clientConfiguration);
        Optional.ofNullable(properties.getEndpoint()).ifPresent(arg_0 -> ((AmazonWebserviceClientFactoryBean)clientFactoryBean).setCustomEndpoint(arg_0));
        return clientFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public CloudWatchConfig cloudWatchConfig(CloudWatchProperties cloudWatchProperties) {
        return new CloudWatchPropertiesConfigAdapter(cloudWatchProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Clock micrometerClock() {
        return Clock.SYSTEM;
    }
}

