/*
 * Decompiled with CFR 0.152.
 */
package io.avaje.inject.test;

import java.util.Collections;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class AnnotationReader {
    private static final Pattern ANNOTATION_TYPE_PATTERN = Pattern.compile("@([\\w.]+)\\.");
    private static final Pattern ANNOTATION_TYPE_PATTERN$ = Pattern.compile("@[\\w.]+\\$");
    private static final Pattern VALUE_ATTRIBUTE_PATTERN = Pattern.compile("(\\w+)=([\\w.]+)");

    private AnnotationReader() {
    }

    static String simplifyAnnotation(String input) {
        String result = ANNOTATION_TYPE_PATTERN$.matcher(input).replaceAll("@");
        result = ANNOTATION_TYPE_PATTERN.matcher(result).replaceAll("@");
        Matcher valueAttributeMatcher = VALUE_ATTRIBUTE_PATTERN.matcher(result);
        StringBuilder sb = new StringBuilder();
        while (valueAttributeMatcher.find()) {
            valueAttributeMatcher.appendReplacement(sb, valueAttributeMatcher.group(1) + "=" + AnnotationReader.shortType(valueAttributeMatcher.group(2)));
        }
        valueAttributeMatcher.appendTail(sb);
        return AnnotationReader.rearrangeAnnotations(sb.toString());
    }

    static String shortType(String fqn) {
        int dotIndex = fqn.lastIndexOf(46);
        int $index = fqn.lastIndexOf(36);
        if (dotIndex == -1 && $index == -1) {
            return fqn;
        }
        if ($index != -1) {
            return fqn.substring($index + 1);
        }
        return fqn.substring(dotIndex + 1);
    }

    static String rearrangeAnnotations(String input) {
        int indexOfParanthesis = input.indexOf(40);
        if (indexOfParanthesis == -1) {
            return input;
        }
        String annotationContent = input.substring(indexOfParanthesis + 1, input.lastIndexOf(41));
        String[] annotations = annotationContent.split(",\\s*");
        TreeSet sortedkeys = new TreeSet();
        Collections.addAll(sortedkeys, annotations);
        StringBuilder sortedOutput = new StringBuilder(input.substring(0, indexOfParanthesis + 1));
        for (String key : sortedkeys) {
            sortedOutput.append(key).append(", ");
        }
        sortedOutput.setLength(sortedOutput.length() - 2);
        sortedOutput.append(")");
        return sortedOutput.toString();
    }
}

