/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.util;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.ServerSelectionStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class AddressSelector
implements Iterator<Address> {
    private Address leader;
    private Collection<Address> servers = new ArrayList<Address>();
    private final ServerSelectionStrategy strategy;
    private Collection<Address> selections = new ArrayList<Address>();
    private Iterator<Address> selectionsIterator;

    public AddressSelector(ServerSelectionStrategy strategy) {
        this.strategy = (ServerSelectionStrategy)Assert.notNull((Object)strategy, (String)"strategy");
    }

    public State state() {
        if (this.selectionsIterator == null) {
            return State.RESET;
        }
        if (this.hasNext()) {
            return State.ITERATE;
        }
        return State.COMPLETE;
    }

    public Address leader() {
        return this.leader;
    }

    public Collection<Address> servers() {
        return this.servers;
    }

    public AddressSelector reset() {
        if (this.selectionsIterator != null) {
            this.selections = this.strategy.selectConnections(this.leader, new ArrayList<Address>(this.servers));
            this.selectionsIterator = null;
        }
        return this;
    }

    public AddressSelector reset(Address leader, Collection<Address> servers) {
        if (this.changed(leader, servers)) {
            this.leader = leader;
            this.servers = servers;
            this.selections = this.strategy.selectConnections(leader, new ArrayList<Address>(servers));
            this.selectionsIterator = null;
        }
        return this;
    }

    private boolean changed(Address leader, Collection<Address> servers) {
        Assert.notNull(servers, (String)"servers");
        Assert.argNot((boolean)servers.isEmpty(), (String)"servers list cannot be empty", (Object[])new Object[0]);
        if (this.leader != null && leader == null) {
            return true;
        }
        if (this.leader == null && leader != null) {
            Assert.arg((boolean)servers.contains(leader), (String)"leader must be present in servers list", (Object[])new Object[0]);
            return true;
        }
        if (this.leader != null && !this.leader.equals((Object)leader)) {
            Assert.arg((boolean)servers.contains(leader), (String)"leader must be present in servers list", (Object[])new Object[0]);
            return true;
        }
        return !this.matches(this.servers, servers);
    }

    private boolean matches(Collection<Address> left, Collection<Address> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (Address address : left) {
            if (right.contains(address)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.selectionsIterator == null ? !this.selections.isEmpty() : this.selectionsIterator.hasNext();
    }

    @Override
    public Address next() {
        if (this.selectionsIterator == null) {
            this.selectionsIterator = this.selections.iterator();
        }
        return this.selectionsIterator.next();
    }

    public String toString() {
        return String.format("%s[strategy=%s]", this.getClass().getSimpleName(), this.strategy);
    }

    public static enum State {
        RESET,
        ITERATE,
        COMPLETE;

    }
}

