/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.DirectBytes;
import io.atomix.catalyst.buffer.NativeBuffer;
import io.atomix.catalyst.buffer.util.DirectMemory;
import io.atomix.catalyst.buffer.util.Memory;
import io.atomix.catalyst.util.reference.ReferenceManager;

public class DirectBuffer
extends NativeBuffer {
    public static DirectBuffer allocate() {
        return DirectBuffer.allocate(4096L, Long.MAX_VALUE);
    }

    public static DirectBuffer allocate(long initialCapacity) {
        return DirectBuffer.allocate(initialCapacity, Long.MAX_VALUE);
    }

    public static DirectBuffer allocate(long initialCapacity, long maxCapacity) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        return new DirectBuffer(new DirectBytes(DirectMemory.allocate(Memory.Util.toPow2(initialCapacity))), 0L, initialCapacity, maxCapacity);
    }

    protected DirectBuffer(DirectBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity);
    }

    protected DirectBuffer(DirectBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
    }
}

