/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables.internal;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.variables.internal.ValueCommands;
import java.time.Duration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class AbstractValueState<T>
extends ResourceStateMachine {
    protected final Set<ServerSession> listeners = new HashSet<ServerSession>();
    protected T value;
    protected Commit<? extends ValueCommands.ValueCommand<?>> current;
    protected Scheduled timer;

    public AbstractValueState(Properties config) {
        super(config);
    }

    public T get(Commit<ValueCommands.Get<T>> commit) {
        try {
            T t = this.current != null ? (T)this.value : null;
            return t;
        }
        finally {
            commit.close();
        }
    }

    private void cleanCurrent() {
        if (this.current != null) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.current.close();
        }
    }

    private void setCurrent(Commit<? extends ValueCommands.ValueCommand<?>> commit) {
        this.timer = ((ValueCommands.ValueCommand)commit.operation()).ttl() > 0L ? this.executor.schedule(Duration.ofMillis(((ValueCommands.ValueCommand)commit.operation()).ttl()), () -> {
            this.value = null;
            this.current.close();
            this.current = null;
        }) : null;
        this.current = commit;
    }

    public void set(Commit<ValueCommands.Set<T>> commit) {
        this.cleanCurrent();
        this.value = ((ValueCommands.Set)commit.operation()).value();
        this.setCurrent(commit);
    }

    public boolean compareAndSet(Commit<ValueCommands.CompareAndSet<T>> commit) {
        if (this.value == null && ((ValueCommands.CompareAndSet)commit.operation()).expect() == null || this.value != null && ((ValueCommands.CompareAndSet)commit.operation()).expect() != null && this.value.equals(((ValueCommands.CompareAndSet)commit.operation()).expect())) {
            this.value = ((ValueCommands.CompareAndSet)commit.operation()).update();
            this.cleanCurrent();
            this.setCurrent(commit);
            return true;
        }
        commit.close();
        return false;
    }

    public T getAndSet(Commit<ValueCommands.GetAndSet<T>> commit) {
        T result = this.value;
        this.value = ((ValueCommands.GetAndSet)commit.operation()).value();
        this.cleanCurrent();
        this.setCurrent(commit);
        return result;
    }

    public void delete() {
        if (this.current != null) {
            this.current.close();
            this.current = null;
            this.value = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }
}

