/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import io.atomix.utils.concurrent.NullThreadContext;
import io.atomix.utils.concurrent.ThreadContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class AtomixFuture<T>
extends CompletableFuture<T> {
    private static final ThreadContext NULL_CONTEXT = new NullThreadContext();

    public static <T> AtomixFuture<T> wrap(CompletableFuture<T> future) {
        AtomixFuture newFuture = new AtomixFuture();
        future.whenComplete((T result, U error) -> {
            if (error == null) {
                newFuture.complete(result);
            } else {
                newFuture.completeExceptionally((Throwable)error);
            }
        });
        return newFuture;
    }

    public static <T> CompletableFuture<T> completedFuture(T result) {
        AtomixFuture<T> future = new AtomixFuture<T>();
        future.complete(result);
        return future;
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        AtomixFuture<T> future = new AtomixFuture<T>();
        future.completeExceptionally(t);
        return future;
    }

    private ThreadContext getThreadContext() {
        ThreadContext context = ThreadContext.currentContext();
        return context != null ? context : NULL_CONTEXT;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        ThreadContext context = this.getThreadContext();
        context.block();
        try {
            Object t = super.get();
            return t;
        }
        finally {
            context.unblock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ThreadContext context = this.getThreadContext();
        context.block();
        try {
            Object t = super.get(timeout, unit);
            return t;
        }
        finally {
            context.unblock();
        }
    }

    @Override
    public synchronized T join() {
        ThreadContext context = this.getThreadContext();
        context.block();
        try {
            Object t = super.join();
            return t;
        }
        finally {
            context.unblock();
        }
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return AtomixFuture.wrap(super.thenApply((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return AtomixFuture.wrap(super.thenApplyAsync((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return AtomixFuture.wrap(super.thenApplyAsync((Function)fn, executor));
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return AtomixFuture.wrap(super.thenAccept((Consumer)action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return AtomixFuture.wrap(super.thenAcceptAsync((Consumer)action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return AtomixFuture.wrap(super.thenAcceptAsync((Consumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return AtomixFuture.wrap(super.thenRun(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return AtomixFuture.wrap(super.thenRunAsync(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return AtomixFuture.wrap(super.thenRunAsync(action, executor));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return AtomixFuture.wrap(super.thenCombine((CompletionStage)other, (BiFunction)fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return AtomixFuture.wrap(super.thenCombineAsync((CompletionStage)other, (BiFunction)fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return AtomixFuture.wrap(super.thenCombineAsync((CompletionStage)other, (BiFunction)fn, executor));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return AtomixFuture.wrap(super.thenAcceptBoth((CompletionStage)other, (BiConsumer)action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return AtomixFuture.wrap(super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return AtomixFuture.wrap(super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return AtomixFuture.wrap(super.runAfterBoth((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return AtomixFuture.wrap(super.runAfterBothAsync((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return AtomixFuture.wrap(super.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return AtomixFuture.wrap(super.applyToEither((CompletionStage)other, (Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return AtomixFuture.wrap(super.applyToEitherAsync((CompletionStage)other, (Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return AtomixFuture.wrap(super.applyToEitherAsync((CompletionStage)other, (Function)fn, executor));
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return AtomixFuture.wrap(super.acceptEither((CompletionStage)other, (Consumer)action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return AtomixFuture.wrap(super.acceptEitherAsync((CompletionStage)other, (Consumer)action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return AtomixFuture.wrap(super.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return AtomixFuture.wrap(super.runAfterEither((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return AtomixFuture.wrap(super.runAfterEitherAsync((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return AtomixFuture.wrap(super.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return AtomixFuture.wrap(super.thenCompose((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return AtomixFuture.wrap(super.thenComposeAsync((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return AtomixFuture.wrap(super.thenComposeAsync((Function)fn, executor));
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return AtomixFuture.wrap(super.whenComplete((BiConsumer)action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return AtomixFuture.wrap(super.whenCompleteAsync((BiConsumer)action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return AtomixFuture.wrap(super.whenCompleteAsync((BiConsumer)action, executor));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return AtomixFuture.wrap(super.handle((BiFunction)fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return AtomixFuture.wrap(super.handleAsync((BiFunction)fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return AtomixFuture.wrap(super.handleAsync((BiFunction)fn, executor));
    }
}

