/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.MappedMemoryAllocator;
import io.atomix.utils.memory.NativeMemory;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class MappedMemory
extends NativeMemory {
    public static final long MAX_SIZE = Integer.MAX_VALUE;
    private final MappedByteBuffer buffer;

    public static MappedMemory allocate(File file, int size) {
        return new MappedMemoryAllocator(file).allocate(size);
    }

    public static MappedMemory allocate(File file, FileChannel.MapMode mode, int size) {
        if ((long)size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size cannot be greater than 2147483647");
        }
        return new MappedMemoryAllocator(file, mode).allocate(size);
    }

    public MappedMemory(MappedByteBuffer buffer, MappedMemoryAllocator allocator) {
        super(((DirectBuffer)((Object)buffer)).address(), buffer.capacity(), allocator);
        this.buffer = buffer;
    }

    public void flush() {
        this.buffer.force();
    }

    @Override
    public void free() {
        Cleaner cleaner = ((DirectBuffer)((Object)this.buffer)).cleaner();
        if (cleaner != null) {
            cleaner.clean();
        }
        ((MappedMemoryAllocator)this.allocator).release();
    }

    public void close() {
        this.free();
        ((MappedMemoryAllocator)this.allocator).close();
    }
}

