/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import io.atomix.protocols.raft.service.PropagationStrategy;
import io.atomix.protocols.raft.service.ServiceType;
import java.util.Objects;

public class OpenSessionRequest
extends AbstractRaftRequest {
    private final String member;
    private final String name;
    private final String typeName;
    private final ReadConsistency readConsistency;
    private final long minTimeout;
    private final long maxTimeout;
    private final int revision;
    private final PropagationStrategy propagationStrategy;

    public static Builder newBuilder() {
        return new Builder();
    }

    public OpenSessionRequest(String member, String name, String typeName, ReadConsistency readConsistency, long minTimeout, long maxTimeout, int revision, PropagationStrategy propagationStrategy) {
        this.member = member;
        this.name = name;
        this.typeName = typeName;
        this.readConsistency = readConsistency;
        this.minTimeout = minTimeout;
        this.maxTimeout = maxTimeout;
        this.revision = revision;
        this.propagationStrategy = propagationStrategy;
    }

    public String member() {
        return this.member;
    }

    public String serviceName() {
        return this.name;
    }

    public String serviceType() {
        return this.typeName;
    }

    public ReadConsistency readConsistency() {
        return this.readConsistency;
    }

    public long minTimeout() {
        return this.minTimeout;
    }

    public long maxTimeout() {
        return this.maxTimeout;
    }

    public int revision() {
        return this.revision;
    }

    public PropagationStrategy propagationStrategy() {
        return this.propagationStrategy;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name, this.typeName, this.minTimeout, this.maxTimeout);
    }

    public boolean equals(Object object) {
        if (object instanceof OpenSessionRequest) {
            OpenSessionRequest request = (OpenSessionRequest)object;
            return request.member.equals(this.member) && request.name.equals(this.name) && request.typeName.equals(this.typeName) && request.readConsistency == this.readConsistency && request.minTimeout == this.minTimeout && request.maxTimeout == this.maxTimeout && request.revision == this.revision && request.propagationStrategy == this.propagationStrategy;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node", (Object)this.member).add("serviceName", (Object)this.name).add("serviceType", (Object)this.typeName).add("readConsistency", (Object)this.readConsistency).add("minTimeout", this.minTimeout).add("maxTimeout", this.maxTimeout).add("revision", this.revision).add("synchronizationStrategy", (Object)this.propagationStrategy).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, OpenSessionRequest> {
        private String memberId;
        private String serviceName;
        private String serviceType;
        private ReadConsistency readConsistency = ReadConsistency.LINEARIZABLE;
        private long minTimeout;
        private long maxTimeout;
        private int revision;
        private PropagationStrategy propagationStrategy;

        public Builder withMemberId(MemberId member) {
            this.memberId = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)member, (Object)"node cannot be null")).id());
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName cannot be null");
            return this;
        }

        public Builder withServiceType(ServiceType serviceType) {
            this.serviceType = (String)((Object)((ServiceType)Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType cannot be null")).id());
            return this;
        }

        public Builder withReadConsistency(ReadConsistency readConsistency) {
            this.readConsistency = (ReadConsistency)((Object)Preconditions.checkNotNull((Object)((Object)readConsistency), (Object)"readConsistency cannot be null"));
            return this;
        }

        public Builder withMinTimeout(long timeout) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
            this.minTimeout = timeout;
            return this;
        }

        public Builder withMaxTimeout(long timeout) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
            this.maxTimeout = timeout;
            return this;
        }

        public Builder withRevision(int revision) {
            Preconditions.checkArgument((revision >= 0 ? 1 : 0) != 0, (Object)"revision must be positive");
            this.revision = revision;
            return this;
        }

        public Builder withPropagationStrategy(PropagationStrategy propagationStrategy) {
            this.propagationStrategy = (PropagationStrategy)Preconditions.checkNotNull((Object)propagationStrategy);
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull((Object)this.memberId, (Object)"client cannot be null");
            Preconditions.checkNotNull((Object)this.serviceName, (Object)"name cannot be null");
            Preconditions.checkNotNull((Object)this.serviceType, (Object)"typeName cannot be null");
            Preconditions.checkArgument((this.minTimeout >= 0L ? 1 : 0) != 0, (Object)"minTimeout must be positive");
            Preconditions.checkArgument((this.maxTimeout >= 0L ? 1 : 0) != 0, (Object)"maxTimeout must be positive");
            Preconditions.checkArgument((this.revision >= 0 ? 1 : 0) != 0, (Object)"revision must be positive");
        }

        public OpenSessionRequest build() {
            this.validate();
            return new OpenSessionRequest(this.memberId, this.serviceName, this.serviceType, this.readConsistency, this.minTimeout, this.maxTimeout, this.revision, this.propagationStrategy);
        }
    }
}

