/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBytes;
import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.UnsafeHeapBytes;
import io.atomix.storage.buffer.WrappedBytes;
import io.atomix.utils.memory.HeapMemory;
import io.atomix.utils.memory.Memory;
import io.atomix.utils.memory.NativeMemory;
import java.nio.ByteOrder;

public abstract class NativeBytes
extends AbstractBytes {
    private static final boolean NATIVE_ORDER = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    protected NativeMemory memory;

    protected NativeBytes(NativeMemory memory) {
        this.memory = memory;
    }

    @Override
    public int size() {
        return this.memory.size();
    }

    @Override
    public Bytes resize(int newSize) {
        this.memory = (NativeMemory)this.memory.allocator().reallocate((Memory)this.memory, newSize);
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public Bytes zero() {
        return this.zero(0, this.memory.size());
    }

    @Override
    public Bytes zero(int offset) {
        return this.zero(offset, this.memory.size() - offset);
    }

    @Override
    public Bytes zero(int offset, int length) {
        this.memory.unsafe().setMemory(this.memory.address(offset), length, (byte)0);
        return this;
    }

    @Override
    public Bytes read(int position, Bytes bytes, int offset, int length) {
        this.checkRead(position, length);
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(this.memory.address(position), ((NativeBytes)bytes).memory.address(), length);
        } else if (bytes instanceof UnsafeHeapBytes) {
            this.memory.unsafe().copyMemory(null, this.memory.address(position), ((UnsafeHeapBytes)bytes).memory.array(), ((UnsafeHeapBytes)bytes).memory.address(offset), length);
        } else {
            for (int i = 0; i < length; ++i) {
                bytes.writeByte(offset + i, this.memory.getByte(position + i));
            }
        }
        return this;
    }

    @Override
    public Bytes read(int position, byte[] bytes, int offset, int length) {
        this.checkRead(position, length);
        this.memory.unsafe().copyMemory(null, this.memory.address(position), bytes, HeapMemory.ARRAY_BASE_OFFSET + offset, length);
        return this;
    }

    @Override
    public int readByte(int offset) {
        this.checkRead(offset, 1);
        return this.memory.getByte(offset);
    }

    @Override
    public char readChar(int offset) {
        this.checkRead(offset, 2);
        return NATIVE_ORDER ? this.memory.getChar(offset) : Character.reverseBytes(this.memory.getChar(offset));
    }

    @Override
    public short readShort(int offset) {
        this.checkRead(offset, 2);
        return NATIVE_ORDER ? this.memory.getShort(offset) : Short.reverseBytes(this.memory.getShort(offset));
    }

    @Override
    public int readMedium(int offset) {
        this.checkRead(offset, 3);
        return NATIVE_ORDER ? this.memory.getByte(offset) << 16 | (this.memory.getByte(offset + 1) & 0xFF) << 8 | this.memory.getByte(offset + 2) & 0xFF : this.memory.getByte(offset + 2) << 16 | (this.memory.getByte(offset + 1) & 0xFF) << 8 | this.memory.getByte(offset) & 0xFF;
    }

    @Override
    public int readUnsignedMedium(int offset) {
        this.checkRead(offset, 3);
        return NATIVE_ORDER ? (this.memory.getByte(offset) & 0xFF) << 16 | (this.memory.getByte(offset + 1) & 0xFF) << 8 | this.memory.getByte(offset + 2) & 0xFF : (this.memory.getByte(offset + 2) & 0xFF) << 16 | (this.memory.getByte(offset + 1) & 0xFF) << 8 | this.memory.getByte(offset) & 0xFF;
    }

    @Override
    public int readInt(int offset) {
        this.checkRead(offset, 4);
        return NATIVE_ORDER ? this.memory.getInt(offset) : Integer.reverseBytes(this.memory.getInt(offset));
    }

    @Override
    public long readLong(int offset) {
        this.checkRead(offset, 8);
        return NATIVE_ORDER ? this.memory.getLong(offset) : Long.reverseBytes(this.memory.getLong(offset));
    }

    @Override
    public float readFloat(int offset) {
        return Float.intBitsToFloat(this.readInt(offset));
    }

    @Override
    public double readDouble(int offset) {
        return Double.longBitsToDouble(this.readLong(offset));
    }

    @Override
    public Bytes write(int position, Bytes bytes, int offset, int length) {
        this.checkWrite(position, length);
        if (bytes.size() < length) {
            throw new IllegalArgumentException("length is greater than provided byte array size");
        }
        if (bytes instanceof WrappedBytes) {
            bytes = ((WrappedBytes)bytes).root();
        }
        if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(((NativeBytes)bytes).memory.address(offset), this.memory.address(position), length);
        } else if (bytes instanceof UnsafeHeapBytes) {
            this.memory.unsafe().copyMemory(((UnsafeHeapBytes)bytes).memory.array(), ((UnsafeHeapBytes)bytes).memory.address(offset), null, this.memory.address(position), length);
        } else {
            for (int i = 0; i < length; ++i) {
                this.memory.putByte(position + i, (byte)bytes.readByte(offset + i));
            }
        }
        return this;
    }

    @Override
    public Bytes write(int position, byte[] bytes, int offset, int length) {
        this.checkWrite(position, length);
        if (bytes.length < length) {
            throw new IllegalArgumentException("length is greater than provided byte array length");
        }
        this.memory.unsafe().copyMemory(bytes, HeapMemory.ARRAY_BASE_OFFSET + offset, null, this.memory.address(position), length);
        return this;
    }

    @Override
    public Bytes writeByte(int offset, int b) {
        this.checkWrite(offset, 1);
        this.memory.putByte(offset, (byte)b);
        return this;
    }

    @Override
    public Bytes writeChar(int offset, char c) {
        this.checkWrite(offset, 2);
        this.memory.putChar(offset, NATIVE_ORDER ? c : Character.reverseBytes(c));
        return this;
    }

    @Override
    public Bytes writeShort(int offset, short s) {
        this.checkWrite(offset, 2);
        this.memory.putShort(offset, NATIVE_ORDER ? s : Short.reverseBytes(s));
        return this;
    }

    @Override
    public Bytes writeMedium(int offset, int m) {
        if (NATIVE_ORDER) {
            this.memory.putByte(offset, (byte)(m >>> 16));
            this.memory.putByte(offset + 1, (byte)(m >>> 8));
            this.memory.putByte(offset + 2, (byte)m);
        } else {
            this.memory.putByte(offset + 2, (byte)(m >>> 16));
            this.memory.putByte(offset + 1, (byte)(m >>> 8));
            this.memory.putByte(offset, (byte)m);
        }
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(int offset, int m) {
        return this.writeMedium(offset, m);
    }

    @Override
    public Bytes writeInt(int offset, int i) {
        this.checkWrite(offset, 4);
        this.memory.putInt(offset, NATIVE_ORDER ? i : Integer.reverseBytes(i));
        return this;
    }

    @Override
    public Bytes writeLong(int offset, long l) {
        this.checkWrite(offset, 8);
        this.memory.putLong(offset, NATIVE_ORDER ? l : Long.reverseBytes(l));
        return this;
    }

    @Override
    public Bytes writeFloat(int offset, float f) {
        return this.writeInt(offset, Float.floatToRawIntBits(f));
    }

    @Override
    public Bytes writeDouble(int offset, double d) {
        return this.writeLong(offset, Double.doubleToRawLongBits(d));
    }

    @Override
    public void close() {
        this.flush();
        this.memory.free();
        super.close();
    }
}

