/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBuffer;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.Bytes;
import io.atomix.utils.concurrent.ReferenceManager;
import java.nio.ReadOnlyBufferException;

public class ReadOnlyBuffer
extends AbstractBuffer {
    private final Buffer root;

    public ReadOnlyBuffer(Buffer buffer, ReferenceManager<Buffer> referenceManager) {
        super(buffer.bytes(), referenceManager);
        this.root = buffer;
    }

    @Override
    public boolean isDirect() {
        return this.root.isDirect();
    }

    @Override
    public boolean isFile() {
        return this.root.isFile();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Buffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    protected void compact(int from, int to, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer duplicate() {
        return new ReadOnlyBuffer(this.root, (ReferenceManager<Buffer>)this.referenceManager);
    }

    @Override
    public Buffer acquire() {
        this.root.acquire();
        return this;
    }

    @Override
    public boolean release() {
        return this.root.release();
    }

    @Override
    public Buffer zero(int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer zero(int offset) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer zero() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBoolean(int offset, boolean b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer write(Buffer buffer) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer write(Bytes bytes) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer write(Bytes bytes, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer write(int offset, Bytes bytes, int srcOffset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer write(byte[] bytes) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer write(byte[] bytes, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer write(int offset, byte[] bytes, int srcOffset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeByte(int b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeByte(int offset, int b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedByte(int b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedByte(int offset, int b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeChar(char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeChar(int offset, char c) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeShort(short s) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeShort(int offset, short s) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedShort(int s) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedShort(int offset, int s) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeMedium(int m) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeMedium(int offset, int m) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedMedium(int m) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedMedium(int offset, int m) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeInt(int i) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeInt(int offset, int i) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedInt(long i) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUnsignedInt(int offset, long i) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeLong(long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeLong(int offset, long l) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeFloat(float f) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeFloat(int offset, float f) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeDouble(double d) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeDouble(int offset, double d) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeBoolean(boolean b) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer writeUTF8(String s) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public Buffer flush() {
        throw new ReadOnlyBufferException();
    }

    @Override
    public void close() {
        this.root.release();
    }
}

