/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import io.atomix.storage.buffer.AbstractBytes;
import io.atomix.storage.buffer.Bytes;
import io.atomix.storage.buffer.NativeBytes;
import io.atomix.utils.memory.HeapMemory;

public class UnsafeHeapBytes
extends AbstractBytes {
    protected HeapMemory memory;

    public static UnsafeHeapBytes allocate(int size) {
        if (size > 0x7FFFFFFA) {
            throw new IllegalArgumentException("size cannot for HeapBytes cannot be greater than 2147483642");
        }
        return new UnsafeHeapBytes(HeapMemory.allocate((int)size));
    }

    public static UnsafeHeapBytes wrap(byte[] bytes) {
        return new UnsafeHeapBytes(HeapMemory.wrap((byte[])bytes));
    }

    protected UnsafeHeapBytes(HeapMemory memory) {
        this.memory = memory;
    }

    public UnsafeHeapBytes copy() {
        return new UnsafeHeapBytes(this.memory.copy());
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.memory.array();
    }

    public UnsafeHeapBytes reset(byte[] array) {
        this.memory.reset(array);
        return this;
    }

    @Override
    public int size() {
        return this.memory.size();
    }

    @Override
    public Bytes resize(int newSize) {
        this.memory = this.memory.allocator().reallocate(this.memory, newSize);
        return this;
    }

    @Override
    public Bytes zero() {
        return this.zero(0, this.memory.size());
    }

    @Override
    public Bytes zero(int offset) {
        return this.zero(offset, this.memory.size() - offset);
    }

    @Override
    public Bytes zero(int offset, int length) {
        this.memory.unsafe().setMemory(this.memory.array(), this.memory.address(offset), length, (byte)0);
        return this;
    }

    @Override
    public Bytes read(int position, Bytes bytes, int offset, int length) {
        this.checkRead(position, length);
        if (bytes instanceof UnsafeHeapBytes) {
            this.memory.unsafe().copyMemory(this.memory.array(), this.memory.address(position), ((UnsafeHeapBytes)bytes).memory.array(), ((UnsafeHeapBytes)bytes).memory.address(offset), length);
        } else if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(this.memory.array(), this.memory.address(position), null, ((NativeBytes)bytes).memory.address(offset), length);
        } else {
            for (int i = 0; i < length; ++i) {
                bytes.writeByte(offset + i, this.memory.getByte(position + i));
            }
        }
        return this;
    }

    @Override
    public Bytes read(int position, byte[] bytes, int offset, int length) {
        this.checkRead(position, length);
        this.memory.unsafe().copyMemory(this.memory.array(), this.memory.address(position), bytes, this.memory.address(offset), length);
        return this;
    }

    @Override
    public int readByte(int offset) {
        this.checkRead(offset, 1);
        return this.memory.getByte(offset);
    }

    @Override
    public int readUnsignedByte(int offset) {
        this.checkRead(offset, 1);
        return this.memory.getByte(offset) & 0xFF;
    }

    @Override
    public char readChar(int offset) {
        this.checkRead(offset, 2);
        return this.memory.getChar(offset);
    }

    @Override
    public short readShort(int offset) {
        this.checkRead(offset, 2);
        return this.memory.getShort(offset);
    }

    @Override
    public int readUnsignedShort(int offset) {
        this.checkRead(offset, 2);
        return this.memory.getShort(offset) & 0xFFFF;
    }

    @Override
    public int readMedium(int offset) {
        this.checkRead(offset, 3);
        return this.memory.getByte(offset) << 16 | (this.memory.getByte(offset + 1) & 0xFF) << 8 | this.memory.getByte(offset + 2) & 0xFF;
    }

    @Override
    public int readUnsignedMedium(int offset) {
        this.checkRead(offset, 3);
        return (this.memory.getByte(offset) & 0xFF) << 16 | (this.memory.getByte(offset + 1) & 0xFF) << 8 | this.memory.getByte(offset + 2) & 0xFF;
    }

    @Override
    public int readInt(int offset) {
        this.checkRead(offset, 4);
        return this.memory.getInt(offset);
    }

    @Override
    public long readUnsignedInt(int offset) {
        this.checkRead(offset, 4);
        return (long)this.memory.getInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public long readLong(int offset) {
        this.checkRead(offset, 8);
        return this.memory.getLong(offset);
    }

    @Override
    public float readFloat(int offset) {
        this.checkRead(offset, 4);
        return this.memory.getFloat(offset);
    }

    @Override
    public double readDouble(int offset) {
        this.checkRead(offset, 8);
        return this.memory.getDouble(offset);
    }

    @Override
    public boolean readBoolean(int offset) {
        this.checkRead(offset, 1);
        return this.memory.getByte(offset) == 1;
    }

    @Override
    public Bytes write(int position, Bytes bytes, int offset, int length) {
        this.checkWrite(position, length);
        if (bytes.size() < length) {
            throw new IllegalArgumentException("length is greater than provided byte array size");
        }
        if (bytes instanceof UnsafeHeapBytes) {
            this.memory.unsafe().copyMemory(((UnsafeHeapBytes)bytes).memory.array(), ((UnsafeHeapBytes)bytes).memory.address(offset), this.memory.array(), this.memory.address(position), length);
        } else if (bytes instanceof NativeBytes) {
            this.memory.unsafe().copyMemory(null, ((NativeBytes)bytes).memory.address(offset), this.memory.array(), this.memory.address(position), length);
        } else {
            for (int i = 0; i < length; ++i) {
                this.memory.putByte(position + i, (byte)bytes.readByte(offset + i));
            }
        }
        return this;
    }

    @Override
    public Bytes write(int position, byte[] bytes, int offset, int length) {
        this.checkWrite(position, length);
        if (bytes.length < length) {
            throw new IllegalArgumentException("length is greater than provided byte array length");
        }
        this.memory.unsafe().copyMemory(bytes, this.memory.address(offset), this.memory.array(), this.memory.address(position), length);
        return this;
    }

    @Override
    public Bytes writeByte(int offset, int b) {
        this.checkWrite(offset, 1);
        this.memory.putByte(offset, (byte)b);
        return this;
    }

    @Override
    public Bytes writeUnsignedByte(int offset, int b) {
        this.checkWrite(offset, 1);
        this.memory.putByte(offset, (byte)b);
        return this;
    }

    @Override
    public Bytes writeChar(int offset, char c) {
        this.checkWrite(offset, 2);
        this.memory.putChar(offset, c);
        return this;
    }

    @Override
    public Bytes writeShort(int offset, short s) {
        this.checkWrite(offset, 2);
        this.memory.putShort(offset, s);
        return this;
    }

    @Override
    public Bytes writeUnsignedShort(int offset, int s) {
        this.checkWrite(offset, 2);
        this.memory.putShort(offset, (short)s);
        return this;
    }

    @Override
    public Bytes writeMedium(int offset, int m) {
        this.memory.putByte(offset, (byte)(m >>> 16));
        this.memory.putByte(offset + 1, (byte)(m >>> 8));
        this.memory.putByte(offset + 2, (byte)m);
        return this;
    }

    @Override
    public Bytes writeUnsignedMedium(int offset, int m) {
        return this.writeMedium(offset, m);
    }

    @Override
    public Bytes writeInt(int offset, int i) {
        this.checkWrite(offset, 4);
        this.memory.putInt(offset, i);
        return this;
    }

    @Override
    public Bytes writeUnsignedInt(int offset, long i) {
        this.checkWrite(offset, 4);
        this.memory.putInt(offset, (int)i);
        return this;
    }

    @Override
    public Bytes writeLong(int offset, long l) {
        this.checkWrite(offset, 8);
        this.memory.putLong(offset, l);
        return this;
    }

    @Override
    public Bytes writeFloat(int offset, float f) {
        this.checkWrite(offset, 4);
        this.memory.putFloat(offset, f);
        return this;
    }

    @Override
    public Bytes writeDouble(int offset, double d) {
        this.checkWrite(offset, 8);
        this.memory.putDouble(offset, d);
        return this;
    }

    @Override
    public Bytes writeBoolean(int offset, boolean b) {
        this.checkWrite(offset, 1);
        this.memory.putByte(offset, b ? (byte)1 : 0);
        return this;
    }
}

