/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import com.google.common.collect.Maps;
import io.atomix.core.PrimitivesService;
import io.atomix.rest.AtomixResource;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AtomixResource
@Path(value="/primitives")
public class PrimitivesResource {
    @GET
    @Produces(value={"application/json"})
    public Response getPrimitives(@Context PrimitivesService primitives) {
        Map<String, PrimitiveInfo> primitivesInfo = primitives.getPrimitives().stream().map(info -> Maps.immutableEntry((Object)info.name(), (Object)new PrimitiveInfo(info.name(), info.type().name()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (PrimitiveInfo)e.getValue()));
        return Response.ok(primitivesInfo).build();
    }

    static class PrimitiveInfo {
        private String name;
        private String type;

        PrimitiveInfo(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }
    }
}

