/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.cluster.messaging.ClusterEventService;
import io.atomix.core.Atomix;
import io.atomix.core.PrimitivesService;
import io.atomix.core.utils.EventManager;
import io.atomix.primitive.config.PrimitiveConfig;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.rest.ManagedRestService;
import io.atomix.rest.RestService;
import io.atomix.rest.impl.ConfigPropertyNamingStrategy;
import io.atomix.rest.impl.PartitionGroupDeserializer;
import io.atomix.rest.impl.PrimitiveConfigDeserializer;
import io.atomix.rest.impl.PrimitiveProtocolDeserializer;
import io.atomix.rest.resources.ClusterResource;
import io.atomix.rest.resources.EventsResource;
import io.atomix.rest.resources.MessagesResource;
import io.atomix.rest.resources.PrimitivesResource;
import io.atomix.rest.resources.StatusResource;
import io.atomix.utils.net.Address;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.server.vertx.VertxRequestHandler;
import org.jboss.resteasy.plugins.server.vertx.VertxResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxRestService
implements ManagedRestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxRestService.class);
    private final Atomix atomix;
    private final Address address;
    private final Vertx vertx;
    private HttpServer server;
    private VertxResteasyDeployment deployment;
    private final AtomicBoolean open = new AtomicBoolean();

    public VertxRestService(Atomix atomix, Address address) {
        this.atomix = (Atomix)Preconditions.checkNotNull((Object)atomix, (Object)"atomix cannot be null");
        this.address = (Address)Preconditions.checkNotNull((Object)address, (Object)"address cannot be null");
        this.vertx = Vertx.vertx();
    }

    @Override
    public Address address() {
        return this.address;
    }

    public CompletableFuture<RestService> start() {
        this.server = this.vertx.createHttpServer();
        this.deployment = new VertxResteasyDeployment();
        this.deployment.start();
        this.deployment.getDispatcher().getDefaultContextObjects().put(ClusterMembershipService.class, this.atomix.getMembershipService());
        this.deployment.getDispatcher().getDefaultContextObjects().put(ClusterCommunicationService.class, this.atomix.getCommunicationService());
        this.deployment.getDispatcher().getDefaultContextObjects().put(ClusterEventService.class, this.atomix.getEventService());
        this.deployment.getDispatcher().getDefaultContextObjects().put(PrimitivesService.class, this.atomix.getPrimitivesService());
        this.deployment.getDispatcher().getDefaultContextObjects().put(EventManager.class, new EventManager());
        this.deployment.getRegistry().addPerInstanceResource(StatusResource.class);
        this.deployment.getRegistry().addPerInstanceResource(ClusterResource.class);
        this.deployment.getRegistry().addPerInstanceResource(EventsResource.class);
        this.deployment.getRegistry().addPerInstanceResource(MessagesResource.class);
        this.deployment.getRegistry().addPerInstanceResource(PrimitivesResource.class);
        this.deployment.getDispatcher().getProviderFactory().register((Object)new JacksonProvider(this.createObjectMapper()));
        this.server.requestHandler((Handler)new VertxRequestHandler(this.vertx, (ResteasyDeployment)this.deployment));
        CompletableFuture<RestService> future = new CompletableFuture<RestService>();
        this.server.listen(this.address.port(), this.address.address().getHostAddress(), result -> {
            if (result.succeeded()) {
                this.open.set(true);
                LOGGER.info("Started");
                future.complete(this);
            } else {
                future.completeExceptionally(result.cause());
            }
        });
        return future;
    }

    public boolean isRunning() {
        return this.open.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.server != null) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.server.close(result -> {
                LOGGER.info("Stopped");
                future.complete(null);
            });
            this.deployment.stop();
            return future;
        }
        this.open.set(false);
        return CompletableFuture.completedFuture(null);
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new ConfigPropertyNamingStrategy());
        mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        mapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES});
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.configure(JsonParser.Feature.ALLOW_YAML_COMMENTS, true);
        SimpleModule module = new SimpleModule("PolymorphicTypes");
        module.addDeserializer(PartitionGroupConfig.class, (JsonDeserializer)new PartitionGroupDeserializer(this.atomix.getRegistry()));
        module.addDeserializer(PrimitiveProtocolConfig.class, (JsonDeserializer)new PrimitiveProtocolDeserializer(this.atomix.getRegistry()));
        module.addDeserializer(PrimitiveConfig.class, (JsonDeserializer)new PrimitiveConfigDeserializer(this.atomix.getRegistry()));
        mapper.registerModule((Module)module);
        return mapper;
    }

    @Provider
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    private static class JacksonProvider
    implements ContextResolver<ObjectMapper> {
        private final ObjectMapper mapper;

        JacksonProvider(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public ObjectMapper getContext(Class<?> type) {
            return this.mapper;
        }
    }

    public static class Builder
    extends RestService.Builder {
        private static final String DEFAULT_HOST = "0.0.0.0";
        private static final int DEFAULT_PORT = 5678;

        public ManagedRestService build() {
            if (this.address == null) {
                this.address = Address.from((String)DEFAULT_HOST, (int)5678);
            }
            return new VertxRestService(this.atomix, this.address);
        }
    }
}

