/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.PrimitivesService;
import io.atomix.primitive.DistributedPrimitive;
import io.atomix.primitive.PrimitiveConfig;
import io.atomix.primitive.resource.PrimitiveResource;
import io.atomix.rest.resources.AbstractRestResource;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/v1/primitives")
public class PrimitivesResource
extends AbstractRestResource {
    @Path(value="/{name}")
    public PrimitiveResource getPrimitive(@PathParam(value="name") String name, @Context PrimitivesService primitives) {
        DistributedPrimitive primitive = primitives.getPrimitive(name);
        return (PrimitiveResource)primitive.primitiveType().resourceFactory().apply(primitive);
    }

    @POST
    @Path(value="/{name}")
    @Consumes(value={"application/json"})
    public Response createPrimitive(@PathParam(value="name") String name, PrimitiveConfig config, @Context PrimitivesService primitives) {
        try {
            primitives.getPrimitive(name, config.getType(), config);
            return Response.ok().build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_ACCEPTABLE).build();
        }
    }
}

