/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.election.AsyncLeaderElection;
import io.atomix.core.election.Leadership;
import io.atomix.core.election.LeadershipEvent;
import io.atomix.core.election.LeadershipEventListener;
import io.atomix.rest.utils.EventLog;
import io.atomix.rest.utils.EventManager;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderElectorResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderElectorResource.class);
    private final AsyncLeaderElection<String> leaderElector;

    public LeaderElectorResource(AsyncLeaderElection<String> leaderElector) {
        this.leaderElector = leaderElector;
    }

    private String getEventLogName(String id) {
        return String.format("%s-%s", this.leaderElector.name(), id);
    }

    @POST
    @Produces(value={"application/json"})
    public void run(@Context EventManager events, @Suspended AsyncResponse response) {
        String id = UUID.randomUUID().toString();
        EventLog eventLog = events.getOrCreateEventLog(AsyncLeaderElection.class, this.getEventLogName(id), l -> e -> l.addEvent(e));
        this.leaderElector.addListener(eventLog.listener()).whenComplete((listenResult, listenError) -> {
            if (listenError == null) {
                this.leaderElector.run((Object)id).whenComplete((runResult, runError) -> {
                    if (runError == null) {
                        response.resume((Object)Response.ok((Object)id).build());
                    } else {
                        LOGGER.warn("{}", runError);
                        response.resume((Object)Response.serverError().build());
                    }
                });
            } else {
                LOGGER.warn("{}", listenError);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Produces(value={"application/json"})
    public void getLeadership(@Suspended AsyncResponse response) {
        this.leaderElector.getLeadership().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)new LeadershipResponse((Leadership<String>)result)).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @GET
    @Path(value="/{id}")
    public void listen(@PathParam(value="id") String id, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog<LeadershipEventListener<String>, LeadershipEvent<String>> eventLog = events.getEventLog(AsyncLeaderElection.class, this.getEventLogName(id));
        this.consumeNextEvent(eventLog, id, response);
    }

    private void consumeNextEvent(EventLog<LeadershipEventListener<String>, LeadershipEvent<String>> eventLog, String id, AsyncResponse response) {
        eventLog.nextEvent().whenComplete((event, error) -> {
            if (error == null) {
                if (event.newLeadership().leader() != null && ((String)event.newLeadership().leader().id()).equals(id)) {
                    response.resume((Object)Response.ok((Object)new LeadershipResponse((Leadership<String>)event.newLeadership())).build());
                } else if (event.newLeadership().candidates().stream().noneMatch(c -> c.equals(id))) {
                    this.leaderElector.removeListener((LeadershipEventListener)eventLog.listener()).whenComplete((removeResult, removeError) -> response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build()));
                }
            } else {
                response.resume((Object)Response.status((Response.Status)Response.Status.NOT_FOUND).build());
            }
        });
    }

    @DELETE
    @Path(value="/{id}")
    public void withdraw(@PathParam(value="id") String id, @Context EventManager events, @Suspended AsyncResponse response) {
        EventLog eventLog = events.removeEventLog(AsyncLeaderElection.class, this.getEventLogName(id));
        if (eventLog != null && eventLog.close()) {
            this.leaderElector.removeListener((LeadershipEventListener)eventLog.listener()).whenComplete((removeResult, removeError) -> this.leaderElector.withdraw((Object)id).whenComplete((withdrawResult, withdrawError) -> {
                if (withdrawError == null) {
                    response.resume((Object)Response.ok().build());
                } else {
                    LOGGER.warn("{}", removeError);
                    response.resume((Object)Response.serverError().build());
                }
            }));
        } else {
            response.resume((Object)Response.ok().build());
        }
    }

    @POST
    @Path(value="/{id}/anoint")
    public void anoint(@PathParam(value="id") String id, @Suspended AsyncResponse response) {
        this.leaderElector.anoint((Object)id).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{id}/promote")
    public void promote(@PathParam(value="id") String id, @Suspended AsyncResponse response) {
        this.leaderElector.promote((Object)id).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @POST
    @Path(value="/{id}/evict")
    public void evict(@PathParam(value="id") String id, @Suspended AsyncResponse response) {
        this.leaderElector.evict((Object)id).whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    static class LeadershipResponse {
        private final Leadership<String> leadership;

        public LeadershipResponse(Leadership<String> leadership) {
            this.leadership = leadership;
        }

        public String getLeader() {
            return this.leadership.leader() != null ? (String)this.leadership.leader().id() : null;
        }

        public List<String> getCandidates() {
            return this.leadership.candidates();
        }
    }
}

