/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.rest.resources;

import io.atomix.core.lock.AsyncDistributedLock;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockResource.class);
    private final AsyncDistributedLock lock;

    public DistributedLockResource(AsyncDistributedLock lock) {
        this.lock = lock;
    }

    @POST
    @Produces(value={"application/json"})
    public void lock(@Suspended AsyncResponse response) {
        this.lock.lock().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok((Object)result.value()).build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }

    @DELETE
    public void unlock(@Suspended AsyncResponse response) {
        this.lock.unlock().whenComplete((result, error) -> {
            if (error == null) {
                response.resume((Object)Response.ok().build());
            } else {
                LOGGER.warn("{}", error);
                response.resume((Object)Response.serverError().build());
            }
        });
    }
}

