/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.system;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.utils.serializer.Serializer;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStore
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Serializer serializer;
    private final FileBuffer metadataBuffer;
    private final Buffer configurationBuffer;

    public MetaStore(RaftStorage storage, Serializer serializer) {
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        if (!storage.directory().isDirectory() && !storage.directory().mkdirs()) {
            throw new IllegalArgumentException(String.format("Can't create storage directory [%s].", storage.directory()));
        }
        File metaFile = new File(storage.directory(), String.format("%s.meta", storage.prefix()));
        this.metadataBuffer = FileBuffer.allocate((File)metaFile, (int)12);
        if (storage.storageLevel() == StorageLevel.MEMORY) {
            this.configurationBuffer = HeapBuffer.allocate((int)32);
        } else {
            File confFile = new File(storage.directory(), String.format("%s.conf", storage.prefix()));
            this.configurationBuffer = FileBuffer.allocate((File)confFile, (int)32);
        }
    }

    public synchronized void storeTerm(long term) {
        this.log.trace("Store term {}", (Object)term);
        this.metadataBuffer.writeLong(0, term).flush();
    }

    public synchronized long loadTerm() {
        return this.metadataBuffer.readLong(0);
    }

    public synchronized void storeVote(MemberId vote) {
        this.log.trace("Store vote {}", (Object)vote);
        this.metadataBuffer.writeString(8, vote != null ? (String)((Object)vote.id()) : null).flush();
    }

    public synchronized MemberId loadVote() {
        String id = this.metadataBuffer.readString(8);
        return id != null ? MemberId.from((String)id) : null;
    }

    public synchronized void storeConfiguration(Configuration configuration) {
        this.log.trace("Store configuration {}", (Object)configuration);
        byte[] bytes = this.serializer.encode((Object)configuration);
        this.configurationBuffer.position(0).writeByte(1).writeInt(bytes.length).write(bytes);
        this.configurationBuffer.flush();
    }

    public synchronized Configuration loadConfiguration() {
        if (this.configurationBuffer.position(0).readByte() == 1) {
            int bytesLength = this.configurationBuffer.readInt();
            if (bytesLength == 0) {
                return null;
            }
            return (Configuration)this.serializer.decode(this.configurationBuffer.readBytes(bytesLength));
        }
        return null;
    }

    @Override
    public synchronized void close() {
        this.metadataBuffer.close();
        this.configurationBuffer.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

