/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.session.SessionMetadata;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.AbstractRaftResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class MetadataResponse
extends AbstractRaftResponse {
    private final Set<SessionMetadata> sessions;

    public static Builder builder() {
        return new Builder();
    }

    public MetadataResponse(RaftResponse.Status status, RaftError error, Set<SessionMetadata> sessions) {
        super(status, error);
        this.sessions = sessions;
    }

    public Set<SessionMetadata> sessions() {
        return this.sessions;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("sessions", this.sessions).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, MetadataResponse> {
        private Set<SessionMetadata> sessions;

        public Builder withSessions(SessionMetadata ... sessions) {
            return this.withSessions(Arrays.asList((SessionMetadata[])Preconditions.checkNotNull((Object)sessions, (Object)"sessions cannot be null")));
        }

        public Builder withSessions(Collection<SessionMetadata> sessions) {
            this.sessions = new HashSet<SessionMetadata>((Collection)Preconditions.checkNotNull(sessions, (Object)"sessions cannot be null"));
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkNotNull(this.sessions, (Object)"sessions cannot be null");
            }
        }

        public MetadataResponse build() {
            this.validate();
            return new MetadataResponse(this.status, this.error, this.sessions);
        }
    }
}

