/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.raft.protocol.SessionRequest;
import java.util.Objects;

public class CloseSessionRequest
extends SessionRequest {
    private final boolean delete;

    public static Builder builder() {
        return new Builder();
    }

    public CloseSessionRequest(long session, boolean delete) {
        super(session);
        this.delete = delete;
    }

    public boolean delete() {
        return this.delete;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass(), this.session);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        CloseSessionRequest request = (CloseSessionRequest)object;
        return request.session == this.session && request.delete == this.delete;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("session", this.session).add("delete", this.delete).toString();
    }

    public static class Builder
    extends SessionRequest.Builder<Builder, CloseSessionRequest> {
        private boolean delete;

        public Builder withDelete(boolean delete) {
            this.delete = delete;
            return this;
        }

        public CloseSessionRequest build() {
            this.validate();
            return new CloseSessionRequest(this.session, this.delete);
        }
    }
}

