/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.session.SessionId;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public final class RaftSessionState {
    private final String clientId;
    private final SessionId sessionId;
    private final String serviceName;
    private final PrimitiveType primitiveType;
    private final long timeout;
    private volatile PrimitiveState state = PrimitiveState.CONNECTED;
    private volatile Long suspendedTime;
    private volatile long commandRequest;
    private volatile long commandResponse;
    private volatile long responseIndex;
    private volatile long eventIndex;
    private final Set<Consumer<PrimitiveState>> changeListeners = new CopyOnWriteArraySet<Consumer<PrimitiveState>>();

    RaftSessionState(String clientId, SessionId sessionId, String serviceName, PrimitiveType primitiveType, long timeout) {
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.serviceName = serviceName;
        this.primitiveType = primitiveType;
        this.timeout = timeout;
        this.responseIndex = (Long)sessionId.id();
        this.eventIndex = (Long)sessionId.id();
    }

    public String getClientId() {
        return this.clientId;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public String getPrimitiveName() {
        return this.serviceName;
    }

    public PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    public long getSessionTimeout() {
        return this.timeout;
    }

    public PrimitiveState getState() {
        return this.state;
    }

    public void setState(PrimitiveState state) {
        if (this.state != state) {
            if (this.state != PrimitiveState.EXPIRED && this.state != PrimitiveState.CLOSED) {
                this.state = state;
                if (state == PrimitiveState.SUSPENDED) {
                    if (this.suspendedTime == null) {
                        this.suspendedTime = System.currentTimeMillis();
                    }
                } else {
                    this.suspendedTime = null;
                }
                this.changeListeners.forEach(l -> l.accept(state));
            }
        } else if (this.state == PrimitiveState.SUSPENDED && System.currentTimeMillis() - this.suspendedTime > this.timeout) {
            this.setState(PrimitiveState.EXPIRED);
        }
    }

    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.changeListeners.add((Consumer)Preconditions.checkNotNull(listener));
    }

    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.changeListeners.remove(Preconditions.checkNotNull(listener));
    }

    public void setCommandRequest(long commandRequest) {
        this.commandRequest = commandRequest;
    }

    public long getCommandRequest() {
        return this.commandRequest;
    }

    public long nextCommandRequest() {
        return ++this.commandRequest;
    }

    public void setCommandResponse(long commandResponse) {
        this.commandResponse = commandResponse;
    }

    public long getCommandResponse() {
        return this.commandResponse;
    }

    public void setResponseIndex(long responseIndex) {
        this.responseIndex = Math.max(this.responseIndex, responseIndex);
    }

    public long getResponseIndex() {
        return this.responseIndex;
    }

    public void setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
    }

    public long getEventIndex() {
        return this.eventIndex;
    }
}

