/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.protocol.ConfigurationResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import java.util.Collection;

public class JoinResponse
extends ConfigurationResponse {
    public static Builder builder() {
        return new Builder();
    }

    public JoinResponse(RaftResponse.Status status, RaftError error, long index, long term, long timestamp, Collection<RaftMember> members) {
        super(status, error, index, term, timestamp, members);
    }

    public static class Builder
    extends ConfigurationResponse.Builder<Builder, JoinResponse> {
        @Override
        protected void validate() {
            Preconditions.checkNotNull((Object)((Object)this.status), (Object)"status cannot be null");
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
                Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
                Preconditions.checkArgument((this.timestamp > 0L ? 1 : 0) != 0, (Object)"time must be positive");
                Preconditions.checkNotNull((Object)this.members, (Object)"members cannot be null");
            }
        }

        public JoinResponse build() {
            this.validate();
            return new JoinResponse(this.status, this.error, this.index, this.term, this.timestamp, this.members);
        }
    }
}

