/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.session.SessionMetadata;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import io.atomix.protocols.raft.session.impl.MemberSelectorManager;
import io.atomix.protocols.raft.session.impl.RaftSessionConnection;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.LoggerContext;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class DefaultRaftMetadataClient
implements RaftMetadataClient {
    private final MemberSelectorManager selectorManager;
    private final RaftSessionConnection connection;

    public DefaultRaftMetadataClient(String clientId, RaftClientProtocol protocol, MemberSelectorManager selectorManager, ThreadContext context) {
        this.selectorManager = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectorManager, (Object)"selectorManager cannot be null");
        this.connection = new RaftSessionConnection(protocol, selectorManager.createSelector(CommunicationStrategy.LEADER), context, LoggerContext.builder(RaftClient.class).addValue((Object)clientId).build());
    }

    @Override
    public MemberId getLeader() {
        return this.selectorManager.leader();
    }

    @Override
    public Collection<MemberId> getMembers() {
        return this.selectorManager.members();
    }

    private CompletableFuture<MetadataResponse> getMetadata() {
        CompletableFuture<MetadataResponse> future = new CompletableFuture<MetadataResponse>();
        this.connection.metadata(MetadataRequest.builder().build()).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == RaftResponse.Status.OK) {
                    future.complete((MetadataResponse)response);
                } else {
                    future.completeExceptionally((Throwable)response.error().createException());
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Set<SessionMetadata>> getSessions() {
        return this.getMetadata().thenApply(MetadataResponse::sessions);
    }

    @Override
    public CompletableFuture<Set<SessionMetadata>> getSessions(PrimitiveType primitiveType) {
        return this.getMetadata().thenApply(response -> response.sessions().stream().filter(s -> s.primitiveType().equals(primitiveType.name())).collect(Collectors.toSet()));
    }

    @Override
    public CompletableFuture<Set<SessionMetadata>> getSessions(PrimitiveType primitiveType, String serviceName) {
        return this.getMetadata().thenApply(response -> response.sessions().stream().filter(s -> s.primitiveType().equals(primitiveType.name()) && s.primitiveName().equals(serviceName)).collect(Collectors.toSet()));
    }
}

