/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.PrimitiveProtocolBuilder;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.raft.MultiRaftProtocol;
import io.atomix.protocols.raft.MultiRaftProtocolConfig;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.session.CommunicationStrategy;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class MultiRaftProtocolBuilder
extends PrimitiveProtocolBuilder<MultiRaftProtocolBuilder, MultiRaftProtocolConfig, MultiRaftProtocol> {
    protected MultiRaftProtocolBuilder(MultiRaftProtocolConfig config) {
        super((PrimitiveProtocolConfig)config);
    }

    public MultiRaftProtocolBuilder withPartitioner(Partitioner<String> partitioner) {
        ((MultiRaftProtocolConfig)this.config).setPartitioner(partitioner);
        return this;
    }

    public MultiRaftProtocolBuilder withMinTimeout(Duration minTimeout) {
        ((MultiRaftProtocolConfig)this.config).setMinTimeout(minTimeout);
        return this;
    }

    public MultiRaftProtocolBuilder withMaxTimeout(Duration maxTimeout) {
        ((MultiRaftProtocolConfig)this.config).setMaxTimeout(maxTimeout);
        return this;
    }

    public MultiRaftProtocolBuilder withReadConsistency(ReadConsistency readConsistency) {
        ((MultiRaftProtocolConfig)this.config).setReadConsistency(readConsistency);
        return this;
    }

    public MultiRaftProtocolBuilder withCommunicationStrategy(CommunicationStrategy communicationStrategy) {
        ((MultiRaftProtocolConfig)this.config).setCommunicationStrategy(communicationStrategy);
        return this;
    }

    public MultiRaftProtocolBuilder withRecoveryStrategy(Recovery recoveryStrategy) {
        ((MultiRaftProtocolConfig)this.config).setRecoveryStrategy(recoveryStrategy);
        return this;
    }

    public MultiRaftProtocolBuilder withMaxRetries(int maxRetries) {
        ((MultiRaftProtocolConfig)this.config).setMaxRetries(maxRetries);
        return this;
    }

    public MultiRaftProtocolBuilder withRetryDelayMillis(long retryDelayMillis) {
        return this.withRetryDelay(Duration.ofMillis(retryDelayMillis));
    }

    public MultiRaftProtocolBuilder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
        return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
    }

    public MultiRaftProtocolBuilder withRetryDelay(Duration retryDelay) {
        ((MultiRaftProtocolConfig)this.config).setRetryDelay(retryDelay);
        return this;
    }

    public MultiRaftProtocol build() {
        return new MultiRaftProtocol((MultiRaftProtocolConfig)this.config);
    }
}

