/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import com.google.common.base.MoreObjects;
import io.atomix.primitive.PrimitiveException;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.OperationResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.InactiveRole;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.storage.log.RaftLogReader;
import io.atomix.protocols.raft.storage.log.RaftLogWriter;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.StorageException;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.time.WallClockTimestamp;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class PassiveRole
extends InactiveRole {
    private PendingSnapshot pendingSnapshot;

    public PassiveRole(RaftContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.PASSIVE;
    }

    @Override
    public CompletableFuture<RaftRole> start() {
        return ((CompletableFuture)super.start().thenRun(this::truncateUncommittedEntries)).thenApply(v -> this);
    }

    private void truncateUncommittedEntries() {
        if (this.role() == RaftServer.Role.PASSIVE) {
            RaftLogWriter writer = this.raft.getLogWriter();
            writer.truncate(this.raft.getCommitIndex());
        }
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        return this.handleAppend(request);
    }

    protected CompletableFuture<AppendResponse> handleAppend(AppendRequest request) {
        CompletableFuture<AppendResponse> future = new CompletableFuture<AppendResponse>();
        if (!this.checkTerm(request, future)) {
            return future;
        }
        if (!this.checkPreviousEntry(request, future)) {
            return future;
        }
        this.appendEntries(request, future);
        return future;
    }

    protected boolean checkTerm(AppendRequest request, CompletableFuture<AppendResponse> future) {
        RaftLogWriter writer = this.raft.getLogWriter();
        if (request.term() < this.raft.getTerm()) {
            this.log.debug("Rejected {}: request term is less than the current term ({})", (Object)request, (Object)this.raft.getTerm());
            return this.failAppend(writer.getLastIndex(), future);
        }
        return true;
    }

    protected boolean checkPreviousEntry(AppendRequest request, CompletableFuture<AppendResponse> future) {
        RaftLogWriter writer = this.raft.getLogWriter();
        RaftLogReader reader = this.raft.getLogReader();
        if (request.prevLogTerm() != 0L) {
            Indexed lastEntry = writer.getLastEntry();
            if (lastEntry != null) {
                if (request.prevLogIndex() > lastEntry.index()) {
                    this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{request, request.prevLogIndex(), lastEntry.index()});
                    return this.failAppend(lastEntry.index(), future);
                }
                if (request.prevLogIndex() < lastEntry.index()) {
                    if (reader.getNextIndex() != request.prevLogIndex()) {
                        reader.reset(request.prevLogIndex());
                    }
                    if (!reader.hasNext()) {
                        this.log.debug("Rejected {}: Previous entry does not exist in the local log", (Object)request);
                        return this.failAppend(lastEntry.index(), future);
                    }
                    Indexed previousEntry = reader.next();
                    if (request.prevLogTerm() != ((RaftLogEntry)previousEntry.entry()).term()) {
                        this.log.debug("Rejected {}: Previous entry term ({}) does not match local log's term for the same entry ({})", new Object[]{request, request.prevLogTerm(), ((RaftLogEntry)previousEntry.entry()).term()});
                        return this.failAppend(request.prevLogIndex() - 1L, future);
                    }
                } else if (request.prevLogTerm() != ((RaftLogEntry)lastEntry.entry()).term()) {
                    this.log.debug("Rejected {}: Previous entry term ({}) does not equal the local log's last term ({})", new Object[]{request, request.prevLogTerm(), ((RaftLogEntry)lastEntry.entry()).term()});
                    return this.failAppend(request.prevLogIndex() - 1L, future);
                }
            } else if (request.prevLogIndex() > 0L) {
                this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index (0)", (Object)request, (Object)request.prevLogIndex());
                return this.failAppend(0L, future);
            }
        }
        return true;
    }

    protected void appendEntries(AppendRequest request, CompletableFuture<AppendResponse> future) {
        long lastEntryIndex = request.prevLogIndex() + (long)request.entries().size();
        long commitIndex = Math.max(this.raft.getCommitIndex(), Math.min(request.commitIndex(), lastEntryIndex));
        long lastLogIndex = request.prevLogIndex();
        if (!request.entries().isEmpty()) {
            RaftLogWriter writer = this.raft.getLogWriter();
            RaftLogReader reader = this.raft.getLogReader();
            if (request.prevLogTerm() == 0L) {
                this.log.debug("Reset first index to {}", (Object)(request.prevLogIndex() + 1L));
                writer.reset(request.prevLogIndex() + 1L);
            }
            for (RaftLogEntry entry : request.entries()) {
                long index = ++lastLogIndex;
                Indexed lastEntry = writer.getLastEntry();
                if (lastEntry != null) {
                    if (lastEntry.index() > index) {
                        if (reader.getNextIndex() != index) {
                            reader.reset(index);
                        }
                        if (!reader.hasNext()) {
                            throw new IllegalStateException("Log reader inconsistent with log writer");
                        }
                        Indexed existingEntry = reader.next();
                        if (((RaftLogEntry)existingEntry.entry()).term() != entry.term()) {
                            writer.truncate(index - 1L);
                            if (!this.appendEntry(index, entry, writer, future)) {
                                return;
                            }
                        }
                    } else if (lastEntry.index() == index) {
                        if (((RaftLogEntry)lastEntry.entry()).term() != entry.term()) {
                            writer.truncate(index - 1L);
                            if (!this.appendEntry(index, entry, writer, future)) {
                                return;
                            }
                        }
                    } else {
                        if (lastEntry.index() != index - 1L) {
                            throw new IllegalStateException("Log writer inconsistent with next append entry index " + index);
                        }
                        if (!this.appendEntry(index, entry, writer, future)) {
                            return;
                        }
                    }
                } else if (!this.appendEntry(index, entry, writer, future)) {
                    return;
                }
                if (this.role().active() || index != commitIndex) continue;
                break;
            }
        }
        this.raft.setFirstCommitIndex(request.commitIndex());
        long previousCommitIndex = this.raft.setCommitIndex(commitIndex);
        if (previousCommitIndex < commitIndex) {
            this.log.trace("Committed entries up to index {}", (Object)commitIndex);
            this.raft.getServiceManager().applyAll(commitIndex);
        }
        this.succeedAppend(lastLogIndex, future);
    }

    private boolean appendEntry(long index, RaftLogEntry entry, RaftLogWriter writer, CompletableFuture<AppendResponse> future) {
        try {
            Indexed indexed = writer.append(entry);
            this.log.trace("Appended {}", (Object)indexed);
        }
        catch (StorageException.TooLarge e) {
            this.log.warn("Entry size exceeds maximum allowed bytes. Ensure Raft storage configuration is consistent on all nodes!");
            return false;
        }
        catch (StorageException.OutOfDiskSpace e) {
            this.log.trace("Append failed: {}", (Throwable)e);
            this.raft.getServiceManager().compact();
            this.failAppend(index - 1L, future);
            return false;
        }
        return true;
    }

    protected boolean failAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(false, lastLogIndex, future);
    }

    protected boolean succeedAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(true, lastLogIndex, future);
    }

    protected boolean completeAppend(boolean succeeded, long lastLogIndex, CompletableFuture<AppendResponse> future) {
        future.complete(this.logResponse(((AppendResponse.Builder)AppendResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withSucceeded(succeeded).withLastLogIndex(lastLogIndex).build()));
        return succeeded;
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getState() != RaftContext.State.READY || this.raft.getLastApplied() < request.session()) {
            this.log.trace("State out of sync, forwarding query to leader");
            return this.queryForward(request);
        }
        RaftSession session = this.raft.getSessions().getSession(request.session());
        if (session == null) {
            this.log.trace("State out of sync, forwarding query to leader");
            return this.queryForward(request);
        }
        if (session.readConsistency() == ReadConsistency.SEQUENTIAL) {
            if (this.raft.getLogWriter().getLastIndex() < this.raft.getCommitIndex()) {
                this.log.trace("State out of sync, forwarding query to leader");
                return this.queryForward(request);
            }
            Indexed entry = new Indexed(request.index(), (Object)new QueryEntry(this.raft.getTerm(), System.currentTimeMillis(), request.session(), request.sequenceNumber(), request.operation()), 0);
            return this.applyQuery((Indexed<QueryEntry>)entry).thenApply(this::logResponse);
        }
        return this.queryForward(request);
    }

    private CompletableFuture<QueryResponse> queryForward(QueryRequest request) {
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        this.log.trace("Forwarding {}", (Object)request);
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::query).exceptionally(error -> ((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    protected CompletableFuture<QueryResponse> queryLocal(Indexed<QueryEntry> entry) {
        return this.applyQuery(entry);
    }

    protected CompletableFuture<QueryResponse> applyQuery(Indexed<QueryEntry> entry) {
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        this.raft.getServiceManager().apply(entry).whenComplete((result, error) -> this.completeOperation((OperationResult)result, QueryResponse.builder(), (Throwable)error, future));
        return future;
    }

    protected <T extends OperationResponse> void completeOperation(OperationResult result, OperationResponse.Builder<?, T> builder, Throwable error, CompletableFuture<T> future) {
        if (result != null) {
            builder.withIndex(result.index());
            builder.withEventIndex(result.eventIndex());
            if (result.failed()) {
                error = result.error();
            }
        }
        if (error == null) {
            if (result == null) {
                future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build());
            } else {
                future.complete(((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.OK)).withResult(result.result()).build());
            }
        } else if (error instanceof CompletionException && error.getCause() instanceof RaftException) {
            future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error.getCause()).getType(), error.getMessage())).build());
        } else if (error instanceof RaftException) {
            future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error).getType(), error.getMessage())).build());
        } else if (error instanceof PrimitiveException.ServiceException) {
            this.log.warn("An application error occurred: {}", error.getCause());
            future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.APPLICATION_ERROR)).build());
        } else {
            this.log.warn("An unexpected error occurred: {}", error);
            future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, error.getMessage())).build());
        }
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        this.log.debug("Received snapshot {} chunk {} from {}", new Object[]{request.snapshotIndex(), request.chunkOffset(), request.leader()});
        if (request.term() < this.raft.getTerm()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request term is less than the local term " + request.term())).build()));
        }
        if (this.raft.getLastApplied() > request.snapshotIndex()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
        }
        Snapshot existingSnapshot = this.raft.getSnapshotStore().getSnapshot(request.snapshotIndex());
        if (existingSnapshot != null) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
        }
        if (this.pendingSnapshot != null && request.snapshotIndex() != this.pendingSnapshot.snapshot().index()) {
            this.log.debug("Rolling back snapshot {}", (Object)this.pendingSnapshot.snapshot().index());
            this.pendingSnapshot.rollback();
            this.pendingSnapshot = null;
        }
        if (this.pendingSnapshot == null) {
            if (request.chunkOffset() > 0) {
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset is invalid")).build()));
            }
            Snapshot snapshot = this.raft.getSnapshotStore().newTemporarySnapshot(request.snapshotIndex(), WallClockTimestamp.from((long)request.snapshotTimestamp()));
            this.pendingSnapshot = new PendingSnapshot(snapshot);
        }
        if ((long)request.chunkOffset() > this.pendingSnapshot.nextOffset()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset does not match the next chunk offset")).build()));
        }
        if ((long)request.chunkOffset() < this.pendingSnapshot.nextOffset()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
        }
        try (SnapshotWriter writer = this.pendingSnapshot.snapshot().openWriter();){
            writer.write(request.data());
        }
        if (request.complete()) {
            this.log.debug("Committing snapshot {}", (Object)this.pendingSnapshot.snapshot().index());
            this.pendingSnapshot.commit();
            this.pendingSnapshot = null;
        } else {
            this.pendingSnapshot.incrementOffset();
        }
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<MetadataResponse> onMetadata(MetadataRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::metadata).exceptionally(error -> ((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot poll RESERVE member")).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), null);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot request vote from RESERVE member")).build()));
    }

    @Override
    public CompletableFuture<CommandResponse> onCommand(CommandRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::command).exceptionally(error -> ((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> onKeepAlive(KeepAliveRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::keepAlive).exceptionally(error -> ((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<OpenSessionResponse> onOpenSession(OpenSessionRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::openSession).exceptionally(error -> ((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> onCloseSession(CloseSessionRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::closeSession).exceptionally(error -> ((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<JoinResponse> onJoin(JoinRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::join).exceptionally(error -> ((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::reconfigure).exceptionally(error -> ((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<LeaveResponse> onLeave(LeaveRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::leave).exceptionally(error -> ((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<Void> stop() {
        if (this.pendingSnapshot != null) {
            this.pendingSnapshot.rollback();
        }
        return super.stop();
    }

    private static class PendingSnapshot {
        private final Snapshot snapshot;
        private long nextOffset;

        public PendingSnapshot(Snapshot snapshot) {
            this.snapshot = snapshot;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public long nextOffset() {
            return this.nextOffset;
        }

        public void incrementOffset() {
            ++this.nextOffset;
        }

        public void commit() {
            this.snapshot.persist().complete();
        }

        public void rollback() {
            this.snapshot.close();
            this.snapshot.delete();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("snapshot", (Object)this.snapshot).add("nextOffset", this.nextOffset).toString();
        }
    }
}

