/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public class OpenSessionRequest
extends AbstractRaftRequest {
    private final String node;
    private final String name;
    private final String typeName;
    private final byte[] config;
    private final ReadConsistency readConsistency;
    private final long minTimeout;
    private final long maxTimeout;

    public static Builder builder() {
        return new Builder();
    }

    public OpenSessionRequest(String node, String name, String typeName, byte[] config, ReadConsistency readConsistency, long minTimeout, long maxTimeout) {
        this.node = node;
        this.name = name;
        this.typeName = typeName;
        this.config = config;
        this.readConsistency = readConsistency;
        this.minTimeout = minTimeout;
        this.maxTimeout = maxTimeout;
    }

    public String node() {
        return this.node;
    }

    public String serviceName() {
        return this.name;
    }

    public String serviceType() {
        return this.typeName;
    }

    public byte[] serviceConfig() {
        return this.config;
    }

    public ReadConsistency readConsistency() {
        return this.readConsistency;
    }

    public long minTimeout() {
        return this.minTimeout;
    }

    public long maxTimeout() {
        return this.maxTimeout;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.name, this.typeName, this.minTimeout, this.maxTimeout);
    }

    public boolean equals(Object object) {
        if (object instanceof OpenSessionRequest) {
            OpenSessionRequest request = (OpenSessionRequest)object;
            return request.node.equals(this.node) && request.name.equals(this.name) && request.typeName.equals(this.typeName) && request.readConsistency == this.readConsistency && request.minTimeout == this.minTimeout && request.maxTimeout == this.maxTimeout;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node", (Object)this.node).add("serviceName", (Object)this.name).add("serviceType", (Object)this.typeName).add("readConsistency", (Object)this.readConsistency).add("minTimeout", this.minTimeout).add("maxTimeout", this.maxTimeout).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, OpenSessionRequest> {
        private String memberId;
        private String serviceName;
        private String serviceType;
        private byte[] serviceConfig;
        private ReadConsistency readConsistency = ReadConsistency.LINEARIZABLE;
        private long minTimeout;
        private long maxTimeout;

        public Builder withMemberId(MemberId node) {
            this.memberId = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)node, (Object)"node cannot be null")).id());
            return this;
        }

        public Builder withServiceName(String serviceName) {
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName cannot be null");
            return this;
        }

        public Builder withServiceType(PrimitiveType primitiveType) {
            this.serviceType = ((PrimitiveType)Preconditions.checkNotNull((Object)primitiveType, (Object)"serviceType cannot be null")).name();
            return this;
        }

        public Builder withServiceConfig(byte[] config) {
            this.serviceConfig = (byte[])Preconditions.checkNotNull((Object)config, (Object)"config cannot be null");
            return this;
        }

        public Builder withReadConsistency(ReadConsistency readConsistency) {
            this.readConsistency = (ReadConsistency)((Object)Preconditions.checkNotNull((Object)((Object)readConsistency), (Object)"readConsistency cannot be null"));
            return this;
        }

        public Builder withMinTimeout(long timeout) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
            this.minTimeout = timeout;
            return this;
        }

        public Builder withMaxTimeout(long timeout) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
            this.maxTimeout = timeout;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull((Object)this.memberId, (Object)"memberId cannot be null");
            Preconditions.checkNotNull((Object)this.serviceName, (Object)"name cannot be null");
            Preconditions.checkNotNull((Object)this.serviceType, (Object)"typeName cannot be null");
            Preconditions.checkNotNull((Object)this.serviceConfig, (Object)"serviceConfig cannot be null");
            Preconditions.checkArgument((this.minTimeout >= 0L ? 1 : 0) != 0, (Object)"minTimeout must be positive");
            Preconditions.checkArgument((this.maxTimeout >= 0L ? 1 : 0) != 0, (Object)"maxTimeout must be positive");
        }

        public OpenSessionRequest build() {
            this.validate();
            return new OpenSessionRequest(this.memberId, this.serviceName, this.serviceType, this.serviceConfig, this.readConsistency, this.minTimeout, this.maxTimeout);
        }
    }
}

