/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.cluster;

import io.atomix.cluster.MemberId;
import io.atomix.protocols.raft.cluster.RaftClusterEventListener;
import io.atomix.protocols.raft.cluster.RaftMember;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface RaftCluster {
    public RaftMember getLeader();

    public long getTerm();

    public void addLeaderElectionListener(Consumer<RaftMember> var1);

    public void removeLeaderElectionListener(Consumer<RaftMember> var1);

    public RaftMember getMember();

    public RaftMember getMember(MemberId var1);

    public Collection<RaftMember> getMembers();

    default public CompletableFuture<Void> bootstrap(MemberId ... cluster) {
        return this.bootstrap(Arrays.asList(cluster));
    }

    public CompletableFuture<Void> bootstrap(Collection<MemberId> var1);

    default public CompletableFuture<Void> listen(MemberId ... cluster) {
        return this.join(Arrays.asList(cluster));
    }

    public CompletableFuture<Void> listen(Collection<MemberId> var1);

    default public CompletableFuture<Void> join(MemberId ... cluster) {
        return this.join(Arrays.asList(cluster));
    }

    public CompletableFuture<Void> join(Collection<MemberId> var1);

    public CompletableFuture<Void> leave();

    public void addListener(RaftClusterEventListener var1);

    public void removeListener(RaftClusterEventListener var1);
}

