/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition.impl;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.protocols.raft.partition.RaftPartitionGroupConfig;
import io.atomix.protocols.raft.partition.impl.RaftNamespaces;
import io.atomix.protocols.raft.partition.impl.RaftServerCommunicator;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.storage.StorageException;
import io.atomix.utils.Managed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionServer
implements Managed<RaftPartitionServer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final long ELECTION_TIMEOUT_MILLIS = 2500L;
    private static final long HEARTBEAT_INTERVAL_MILLIS = 250L;
    private final MemberId localMemberId;
    private final RaftPartition partition;
    private final RaftPartitionGroupConfig config;
    private final ClusterMembershipService membershipService;
    private final ClusterCommunicationService clusterCommunicator;
    private final PrimitiveTypeRegistry primitiveTypes;
    private RaftServer server;

    public RaftPartitionServer(RaftPartition partition, RaftPartitionGroupConfig config, MemberId localMemberId, ClusterMembershipService membershipService, ClusterCommunicationService clusterCommunicator, PrimitiveTypeRegistry primitiveTypes) {
        this.partition = partition;
        this.config = config;
        this.localMemberId = localMemberId;
        this.membershipService = membershipService;
        this.clusterCommunicator = clusterCommunicator;
        this.primitiveTypes = primitiveTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftPartitionServer> start() {
        CompletableFuture<Object> serverOpenFuture;
        this.log.info("Starting server for partition {}", (Object)this.partition.id());
        if (this.partition.members().contains(this.localMemberId)) {
            if (this.server != null && this.server.isRunning()) {
                return CompletableFuture.completedFuture(null);
            }
            RaftPartitionServer raftPartitionServer = this;
            synchronized (raftPartitionServer) {
                try {
                    this.server = this.buildServer();
                }
                catch (StorageException e2) {
                    return Futures.exceptionalFuture((Throwable)e2);
                }
            }
            serverOpenFuture = this.server.bootstrap(this.partition.members());
        } else {
            serverOpenFuture = CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)serverOpenFuture.whenComplete((r, e) -> {
            if (e == null) {
                this.log.debug("Successfully started server for partition {}", (Object)this.partition.id());
            } else {
                this.log.warn("Failed to start server for partition {}", (Object)this.partition.id(), e);
            }
        })).thenApply(v -> this);
    }

    public CompletableFuture<Void> stop() {
        return this.server.shutdown();
    }

    public CompletableFuture<Void> leave() {
        return this.server.leave();
    }

    public void delete() {
        try {
            Files.walkFileTree(this.partition.dataDirectory().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.error("Failed to delete partition: {}", (Throwable)e);
        }
    }

    private RaftServer buildServer() {
        return (RaftServer)RaftServer.builder(this.localMemberId).withName(this.partition.name()).withMembershipService(this.membershipService).withProtocol(new RaftServerCommunicator(this.partition.name(), Serializer.using((Namespace)RaftNamespaces.RAFT_PROTOCOL), this.clusterCommunicator)).withPrimitiveTypes(this.primitiveTypes).withElectionTimeout(Duration.ofMillis(2500L)).withHeartbeatInterval(Duration.ofMillis(250L)).withStorage(RaftStorage.builder().withPrefix(this.partition.name()).withDirectory(this.partition.dataDirectory()).withStorageLevel(this.config.getStorageConfig().getLevel()).withMaxSegmentSize((int)this.config.getStorageConfig().getSegmentSize().bytes()).withMaxEntrySize((int)this.config.getStorageConfig().getMaxEntrySize().bytes()).withFlushOnCommit(this.config.getStorageConfig().isFlushOnCommit()).withDynamicCompaction(this.config.getCompactionConfig().isDynamic()).withFreeDiskBuffer(this.config.getCompactionConfig().getFreeDiskBuffer()).withFreeMemoryBuffer(this.config.getCompactionConfig().getFreeMemoryBuffer()).withSerializer(Serializer.using((Namespace)RaftNamespaces.RAFT_STORAGE)).build()).build();
    }

    public CompletableFuture<Void> join(Collection<MemberId> otherMembers) {
        this.log.info("Joining partition {} ({})", (Object)this.partition.id(), (Object)this.partition.name());
        this.server = this.buildServer();
        return ((CompletableFuture)this.server.join(otherMembers).whenComplete((r, e) -> {
            if (e == null) {
                this.log.debug("Successfully joined partition {} ({})", (Object)this.partition.id(), (Object)this.partition.name());
            } else {
                this.log.warn("Failed to join partition {} ({})", new Object[]{this.partition.id(), this.partition.name(), e});
            }
        })).thenApply(v -> null);
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }
}

