/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition.impl;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.partition.PartitionClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.session.RaftSessionClient;
import io.atomix.utils.Managed;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionClient
implements PartitionClient,
Managed<RaftPartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RaftPartition partition;
    private final MemberId localMemberId;
    private final RaftClientProtocol protocol;
    private RaftClient client;

    public RaftPartitionClient(RaftPartition partition, MemberId localMemberId, RaftClientProtocol protocol) {
        this.partition = partition;
        this.localMemberId = localMemberId;
        this.protocol = protocol;
    }

    public long term() {
        return this.client != null ? this.client.term() : 0L;
    }

    public MemberId leader() {
        return this.client != null ? this.client.leader() : null;
    }

    public RaftSessionClient.Builder sessionBuilder(String primitiveName, PrimitiveType primitiveType, ServiceConfig serviceConfig) {
        return this.client.sessionBuilder(primitiveName, primitiveType, serviceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftPartitionClient> start() {
        RaftPartitionClient raftPartitionClient = this;
        synchronized (raftPartitionClient) {
            this.client = this.newRaftClient(this.protocol);
        }
        return ((CompletableFuture)this.client.connect(this.partition.members()).whenComplete((r, e) -> {
            if (e == null) {
                this.log.debug("Successfully started client for partition {}", (Object)this.partition.id());
            } else {
                this.log.warn("Failed to start client for partition {}", (Object)this.partition.id(), e);
            }
        })).thenApply(v -> null);
    }

    public CompletableFuture<Void> stop() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.client != null;
    }

    private RaftClient newRaftClient(RaftClientProtocol protocol) {
        return (RaftClient)RaftClient.builder().withClientId(this.partition.name()).withPartitionId(this.partition.id()).withMemberId(this.localMemberId).withProtocol(protocol).build();
    }
}

