/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.session.Session;
import io.atomix.primitive.session.SessionEvent;
import io.atomix.primitive.session.SessionEventListener;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.PendingCommand;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.service.RaftServiceContext;
import io.atomix.utils.TimestampPrinter;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.event.Event;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class RaftSession
implements Session {
    private final Logger log;
    private final SessionId sessionId;
    private final NodeId member;
    private final String name;
    private final PrimitiveType primitiveType;
    private final ReadConsistency readConsistency;
    private final long minTimeout;
    private final long maxTimeout;
    private final RaftServerProtocol protocol;
    private final RaftServiceContext context;
    private final RaftContext server;
    private final ThreadContext eventExecutor;
    private volatile Session.State state = Session.State.CLOSED;
    private volatile long lastUpdated;
    private long requestSequence;
    private volatile long commandSequence;
    private volatile long lastApplied;
    private volatile long commandLowWaterMark;
    private volatile long eventIndex;
    private volatile long completeIndex;
    private final Map<Long, List<Runnable>> sequenceQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, List<Runnable>> indexQueries = new HashMap<Long, List<Runnable>>();
    private final Map<Long, PendingCommand> pendingCommands = new HashMap<Long, PendingCommand>();
    private final Map<Long, OperationResult> results = new HashMap<Long, OperationResult>();
    private final Queue<EventHolder> events = new LinkedList<EventHolder>();
    private volatile EventHolder currentEventList;
    private final Set<SessionEventListener> eventListeners = new CopyOnWriteArraySet<SessionEventListener>();

    public RaftSession(SessionId sessionId, NodeId member, String name, PrimitiveType primitiveType, ReadConsistency readConsistency, long minTimeout, long maxTimeout, long lastUpdated, RaftServiceContext context, RaftContext server, ThreadContextFactory threadContextFactory) {
        this.sessionId = sessionId;
        this.member = member;
        this.name = name;
        this.primitiveType = primitiveType;
        this.readConsistency = readConsistency;
        this.minTimeout = minTimeout;
        this.maxTimeout = maxTimeout;
        this.lastUpdated = lastUpdated;
        this.eventIndex = (Long)sessionId.id();
        this.completeIndex = (Long)sessionId.id();
        this.lastApplied = (Long)sessionId.id();
        this.protocol = server.getProtocol();
        this.context = context;
        this.server = server;
        this.eventExecutor = threadContextFactory.createContext();
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(Session.class).addValue((Object)sessionId).add("type", (Object)context.serviceType()).add("name", (Object)context.serviceName()).build());
    }

    public SessionId sessionId() {
        return this.sessionId;
    }

    public String serviceName() {
        return this.name;
    }

    public PrimitiveType serviceType() {
        return this.primitiveType;
    }

    public NodeId nodeId() {
        return this.member;
    }

    public ReadConsistency readConsistency() {
        return this.readConsistency;
    }

    public long minTimeout() {
        return this.minTimeout;
    }

    public long maxTimeout() {
        return this.maxTimeout;
    }

    public RaftServiceContext getService() {
        return this.context;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(long lastUpdated) {
        this.lastUpdated = Math.max(this.lastUpdated, lastUpdated);
    }

    public boolean isTimedOut(long timestamp) {
        long lastUpdated = this.lastUpdated;
        return lastUpdated > 0L && timestamp - lastUpdated > this.maxTimeout;
    }

    public Session.State getState() {
        return this.state;
    }

    private void setState(Session.State state) {
        if (this.state != state) {
            this.state = state;
            this.log.debug("State changed: {}", (Object)state);
            switch (state) {
                case OPEN: {
                    this.eventListeners.forEach(l -> l.onEvent((Event)new SessionEvent(SessionEvent.Type.OPEN, (Session)this, this.getLastUpdated())));
                    break;
                }
                case EXPIRED: {
                    this.eventListeners.forEach(l -> l.onEvent((Event)new SessionEvent(SessionEvent.Type.EXPIRE, (Session)this, this.getLastUpdated())));
                    break;
                }
                case CLOSED: {
                    this.eventListeners.forEach(l -> l.onEvent((Event)new SessionEvent(SessionEvent.Type.CLOSE, (Session)this, this.getLastUpdated())));
                }
            }
        }
    }

    public void addListener(SessionEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeListener(SessionEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public long getRequestSequence() {
        return this.requestSequence;
    }

    public long nextRequestSequence() {
        return this.requestSequence + 1L;
    }

    public void setRequestSequence(long requestSequence) {
        this.requestSequence = Math.max(this.requestSequence, requestSequence);
    }

    public void resetRequestSequence(long requestSequence) {
        if (requestSequence > this.requestSequence) {
            this.requestSequence = requestSequence;
        }
    }

    public long getCommandSequence() {
        return this.commandSequence;
    }

    public long nextCommandSequence() {
        return this.commandSequence + 1L;
    }

    public void setCommandSequence(long sequence) {
        for (long i = this.commandSequence + 1L; i <= sequence; ++i) {
            this.commandSequence = i;
            List<Runnable> queries = this.sequenceQueries.remove(this.commandSequence);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
        }
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    public void setLastApplied(long index) {
        for (long i = this.lastApplied + 1L; i <= index; ++i) {
            this.lastApplied = i;
            List<Runnable> queries = this.indexQueries.remove(this.lastApplied);
            if (queries == null) continue;
            for (Runnable query : queries) {
                query.run();
            }
        }
    }

    public void registerSequenceQuery(long sequence, Runnable query) {
        List queries = this.sequenceQueries.computeIfAbsent(sequence, v -> new LinkedList());
        queries.add(query);
    }

    public void registerIndexQuery(long index, Runnable query) {
        List queries = this.indexQueries.computeIfAbsent(index, v -> new LinkedList());
        queries.add(query);
    }

    public void registerCommand(long sequence, PendingCommand pendingCommand) {
        this.pendingCommands.put(sequence, pendingCommand);
    }

    public PendingCommand getCommand(long sequence) {
        return this.pendingCommands.get(sequence);
    }

    public Collection<PendingCommand> getCommands() {
        return this.pendingCommands.values();
    }

    public PendingCommand removeCommand(long sequence) {
        return this.pendingCommands.remove(sequence);
    }

    public Collection<PendingCommand> clearCommands() {
        ArrayList commands = Lists.newArrayList(this.pendingCommands.values());
        this.pendingCommands.clear();
        return commands;
    }

    public void registerResult(long sequence, OperationResult result) {
        this.setRequestSequence(sequence);
        this.results.put(sequence, result);
    }

    public void clearResults(long sequence) {
        if (sequence > this.commandLowWaterMark) {
            long i = this.commandLowWaterMark + 1L;
            while (i <= sequence) {
                this.results.remove(i);
                this.commandLowWaterMark = i++;
            }
        }
    }

    public OperationResult getResult(long sequence) {
        return this.results.get(sequence);
    }

    public long getEventIndex() {
        return this.eventIndex;
    }

    public void setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
    }

    public void publish(PrimitiveEvent event) {
        Session.State state = this.state;
        Preconditions.checkState((state != Session.State.EXPIRED ? 1 : 0) != 0, (Object)"session is expired");
        Preconditions.checkState((state != Session.State.CLOSED ? 1 : 0) != 0, (Object)"session is closed");
        Preconditions.checkState((this.context.currentOperation() == OperationType.COMMAND ? 1 : 0) != 0, (Object)"session events can only be published during command execution");
        if (this.completeIndex > this.context.currentIndex()) {
            return;
        }
        if (this.currentEventList == null || this.currentEventList.eventIndex != this.context.currentIndex()) {
            long previousIndex = this.eventIndex;
            this.eventIndex = this.context.currentIndex();
            this.currentEventList = new EventHolder(this.eventIndex, previousIndex);
        }
        this.currentEventList.events.add(event);
    }

    public void commit(long index) {
        if (this.currentEventList != null && this.currentEventList.eventIndex == index) {
            this.events.add(this.currentEventList);
            this.sendEvents(this.currentEventList);
            this.currentEventList = null;
        }
        this.setLastApplied(index);
    }

    public long getLastCompleted() {
        EventHolder event = this.events.peek();
        if (event != null && event.eventIndex > this.completeIndex) {
            return event.eventIndex - 1L;
        }
        return this.lastApplied;
    }

    public void setLastCompleted(long lastCompleted) {
        this.completeIndex = lastCompleted;
    }

    private void clearEvents(long index) {
        if (index > this.completeIndex) {
            EventHolder event = this.events.peek();
            while (event != null && event.eventIndex <= index) {
                this.events.remove();
                this.completeIndex = event.eventIndex;
                event = this.events.peek();
            }
            this.completeIndex = index;
        }
    }

    public void resendEvents(long index) {
        this.clearEvents(index);
        for (EventHolder event : this.events) {
            this.sendEvents(event);
        }
    }

    private void sendEvents(EventHolder event) {
        if (this.server.isLeader()) {
            this.eventExecutor.execute(() -> {
                PublishRequest request = ((PublishRequest.Builder)PublishRequest.builder().withSession((Long)this.sessionId().id())).withEventIndex(event.eventIndex).withPreviousIndex(event.previousIndex).withEvents(event.events).build();
                this.log.trace("Sending {}", (Object)request);
                this.protocol.publish(this.member, request);
            });
        }
    }

    public void open() {
        this.setState(Session.State.OPEN);
        this.protocol.registerResetListener(this.sessionId, request -> this.resendEvents(request.index()), (Executor)this.server.getServiceManager().executor());
    }

    public void expire() {
        this.setState(Session.State.EXPIRED);
        this.protocol.unregisterResetListener(this.sessionId);
    }

    public void close() {
        this.setState(Session.State.CLOSED);
        this.protocol.unregisterResetListener(this.sessionId);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.sessionId);
    }

    public boolean equals(Object object) {
        return object instanceof Session && ((Session)object).sessionId() == this.sessionId;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.context).add("session", (Object)this.sessionId).add("timestamp", (Object)TimestampPrinter.of((long)this.lastUpdated)).toString();
    }

    private static class EventHolder {
        private final long eventIndex;
        private final long previousIndex;
        private final List<PrimitiveEvent> events = new LinkedList<PrimitiveEvent>();

        private EventHolder(long eventIndex, long previousIndex) {
            this.eventIndex = eventIndex;
            this.previousIndex = previousIndex;
        }
    }
}

