/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.messaging.ClusterMessagingService;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.partition.impl.RaftMessageContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftServerProtocol;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.protocols.raft.protocol.TransferRequest;
import io.atomix.protocols.raft.protocol.TransferResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class RaftServerCommunicator
implements RaftServerProtocol {
    private final RaftMessageContext context;
    private final Serializer serializer;
    private final ClusterMessagingService clusterCommunicator;

    public RaftServerCommunicator(Serializer serializer, ClusterMessagingService clusterCommunicator) {
        this(null, serializer, clusterCommunicator);
    }

    public RaftServerCommunicator(String prefix, Serializer serializer, ClusterMessagingService clusterCommunicator) {
        this.context = new RaftMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterMessagingService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
    }

    private <T, U> CompletableFuture<U> sendAndReceive(String subject, T request, NodeId nodeId) {
        return this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), NodeId.from((String)((String)((Object)nodeId.id()))));
    }

    @Override
    public CompletableFuture<OpenSessionResponse> openSession(NodeId nodeId, OpenSessionRequest request) {
        return this.sendAndReceive(this.context.openSessionSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> closeSession(NodeId nodeId, CloseSessionRequest request) {
        return this.sendAndReceive(this.context.closeSessionSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(NodeId nodeId, KeepAliveRequest request) {
        return this.sendAndReceive(this.context.keepAliveSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<QueryResponse> query(NodeId nodeId, QueryRequest request) {
        return this.sendAndReceive(this.context.querySubject, request, nodeId);
    }

    @Override
    public CompletableFuture<CommandResponse> command(NodeId nodeId, CommandRequest request) {
        return this.sendAndReceive(this.context.commandSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(NodeId nodeId, MetadataRequest request) {
        return this.sendAndReceive(this.context.metadataSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<JoinResponse> join(NodeId nodeId, JoinRequest request) {
        return this.sendAndReceive(this.context.joinSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<LeaveResponse> leave(NodeId nodeId, LeaveRequest request) {
        return this.sendAndReceive(this.context.leaveSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<ConfigureResponse> configure(NodeId nodeId, ConfigureRequest request) {
        return this.sendAndReceive(this.context.configureSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> reconfigure(NodeId nodeId, ReconfigureRequest request) {
        return this.sendAndReceive(this.context.reconfigureSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<InstallResponse> install(NodeId nodeId, InstallRequest request) {
        return this.sendAndReceive(this.context.installSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<TransferResponse> transfer(NodeId nodeId, TransferRequest request) {
        return this.sendAndReceive(this.context.transferSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<PollResponse> poll(NodeId nodeId, PollRequest request) {
        return this.sendAndReceive(this.context.pollSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<VoteResponse> vote(NodeId nodeId, VoteRequest request) {
        return this.sendAndReceive(this.context.voteSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<AppendResponse> append(NodeId nodeId, AppendRequest request) {
        return this.sendAndReceive(this.context.appendSubject, request, nodeId);
    }

    @Override
    public void publish(NodeId nodeId, PublishRequest request) {
        this.clusterCommunicator.unicast(this.context.publishSubject(request.session()), (Object)request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), NodeId.from((String)((String)((Object)nodeId.id()))));
    }

    @Override
    public CompletableFuture<HeartbeatResponse> heartbeat(NodeId nodeId, HeartbeatRequest request) {
        return this.sendAndReceive(this.context.heartbeatSubject, request, nodeId);
    }

    @Override
    public void registerOpenSessionHandler(Function<OpenSessionRequest, CompletableFuture<OpenSessionResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.openSessionSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterOpenSessionHandler() {
        this.clusterCommunicator.unsubscribe(this.context.openSessionSubject);
    }

    @Override
    public void registerCloseSessionHandler(Function<CloseSessionRequest, CompletableFuture<CloseSessionResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.closeSessionSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterCloseSessionHandler() {
        this.clusterCommunicator.unsubscribe(this.context.closeSessionSubject);
    }

    @Override
    public void registerKeepAliveHandler(Function<KeepAliveRequest, CompletableFuture<KeepAliveResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.keepAliveSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterKeepAliveHandler() {
        this.clusterCommunicator.unsubscribe(this.context.keepAliveSubject);
    }

    @Override
    public void registerQueryHandler(Function<QueryRequest, CompletableFuture<QueryResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.querySubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterQueryHandler() {
        this.clusterCommunicator.unsubscribe(this.context.querySubject);
    }

    @Override
    public void registerCommandHandler(Function<CommandRequest, CompletableFuture<CommandResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.commandSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterCommandHandler() {
        this.clusterCommunicator.unsubscribe(this.context.commandSubject);
    }

    @Override
    public void registerMetadataHandler(Function<MetadataRequest, CompletableFuture<MetadataResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.metadataSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterMetadataHandler() {
        this.clusterCommunicator.unsubscribe(this.context.metadataSubject);
    }

    @Override
    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.joinSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterJoinHandler() {
        this.clusterCommunicator.unsubscribe(this.context.joinSubject);
    }

    @Override
    public void registerLeaveHandler(Function<LeaveRequest, CompletableFuture<LeaveResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.leaveSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterLeaveHandler() {
        this.clusterCommunicator.unsubscribe(this.context.leaveSubject);
    }

    @Override
    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.configureSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterConfigureHandler() {
        this.clusterCommunicator.unsubscribe(this.context.configureSubject);
    }

    @Override
    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.reconfigureSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterReconfigureHandler() {
        this.clusterCommunicator.unsubscribe(this.context.reconfigureSubject);
    }

    @Override
    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.installSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterInstallHandler() {
        this.clusterCommunicator.unsubscribe(this.context.installSubject);
    }

    @Override
    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.transferSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterTransferHandler() {
        this.clusterCommunicator.unsubscribe(this.context.transferSubject);
    }

    @Override
    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.pollSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterPollHandler() {
        this.clusterCommunicator.unsubscribe(this.context.pollSubject);
    }

    @Override
    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.voteSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterVoteHandler() {
        this.clusterCommunicator.unsubscribe(this.context.voteSubject);
    }

    @Override
    public void registerAppendHandler(Function<AppendRequest, CompletableFuture<AppendResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.appendSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterAppendHandler() {
        this.clusterCommunicator.unsubscribe(this.context.appendSubject);
    }

    @Override
    public void registerResetListener(SessionId sessionId, Consumer<ResetRequest> listener, Executor executor) {
        this.clusterCommunicator.subscribe(this.context.resetSubject((Long)sessionId.id()), arg_0 -> ((Serializer)this.serializer).decode(arg_0), listener, executor);
    }

    @Override
    public void unregisterResetListener(SessionId sessionId) {
        this.clusterCommunicator.unsubscribe(this.context.resetSubject((Long)sessionId.id()));
    }
}

