/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition.impl;

import io.atomix.cluster.ClusterService;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.messaging.ClusterMessagingService;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.protocols.raft.partition.impl.RaftNamespaces;
import io.atomix.protocols.raft.partition.impl.RaftServerCommunicator;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.utils.Managed;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionServer
implements Managed<RaftPartitionServer> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_SEGMENT_SIZE = 0x4000000;
    private static final long ELECTION_TIMEOUT_MILLIS = 2500L;
    private static final long HEARTBEAT_INTERVAL_MILLIS = 250L;
    private final NodeId localNodeId;
    private final RaftPartition partition;
    private final ClusterService clusterService;
    private final ClusterMessagingService clusterCommunicator;
    private final PrimitiveTypeRegistry primitiveTypes;
    private RaftServer server;

    public RaftPartitionServer(RaftPartition partition, NodeId localNodeId, ClusterService clusterService, ClusterMessagingService clusterCommunicator, PrimitiveTypeRegistry primitiveTypes) {
        this.partition = partition;
        this.localNodeId = localNodeId;
        this.clusterService = clusterService;
        this.clusterCommunicator = clusterCommunicator;
        this.primitiveTypes = primitiveTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftPartitionServer> start() {
        CompletableFuture<Object> serverOpenFuture;
        this.log.info("Starting server for partition {}", (Object)this.partition.id());
        if (this.partition.members().contains(this.localNodeId)) {
            if (this.server != null && this.server.isRunning()) {
                return CompletableFuture.completedFuture(null);
            }
            RaftPartitionServer raftPartitionServer = this;
            synchronized (raftPartitionServer) {
                this.server = this.buildServer();
            }
            serverOpenFuture = this.server.bootstrap(this.partition.members());
        } else {
            serverOpenFuture = CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)serverOpenFuture.whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully started server for partition {}", (Object)this.partition.id());
            } else {
                this.log.info("Failed to start server for partition {}", (Object)this.partition.id(), e);
            }
        })).thenApply(v -> this);
    }

    public CompletableFuture<Void> stop() {
        return this.server.shutdown();
    }

    public CompletableFuture<Void> leave() {
        return this.server.leave();
    }

    public void delete() {
        try {
            Files.walkFileTree(this.partition.dataDirectory().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.error("Failed to delete partition: {}", (Throwable)e);
        }
    }

    private RaftServer buildServer() {
        return (RaftServer)RaftServer.builder(this.localNodeId).withName(this.partition.name()).withClusterService(this.clusterService).withProtocol(new RaftServerCommunicator(this.partition.name(), Serializer.using((Namespace)RaftNamespaces.RAFT_PROTOCOL), this.clusterCommunicator)).withPrimitiveTypes(this.primitiveTypes).withElectionTimeout(Duration.ofMillis(2500L)).withHeartbeatInterval(Duration.ofMillis(250L)).withStorage(RaftStorage.builder().withPrefix(this.partition.name()).withStorageLevel(this.partition.storageLevel()).withSerializer(Serializer.using((Namespace)RaftNamespaces.RAFT_STORAGE)).withDirectory(this.partition.dataDirectory()).withMaxSegmentSize(0x4000000).build()).build();
    }

    public CompletableFuture<Void> join(Collection<NodeId> otherMembers) {
        this.log.info("Joining partition {} ({})", (Object)this.partition.id(), (Object)this.partition.name());
        this.server = this.buildServer();
        return ((CompletableFuture)this.server.join(otherMembers).whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully joined partition {} ({})", (Object)this.partition.id(), (Object)this.partition.name());
            } else {
                this.log.info("Failed to join partition {} ({})", new Object[]{this.partition.id(), this.partition.name(), e});
            }
        })).thenApply(v -> null);
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }
}

