/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.cluster.messaging.ClusterMessagingService;
import io.atomix.primitive.session.SessionId;
import io.atomix.protocols.raft.partition.impl.RaftMessageContext;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.HeartbeatRequest;
import io.atomix.protocols.raft.protocol.HeartbeatResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PublishRequest;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.ResetRequest;
import io.atomix.utils.serializer.Serializer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;

public class RaftClientCommunicator
implements RaftClientProtocol {
    private final RaftMessageContext context;
    private final Serializer serializer;
    private final ClusterMessagingService clusterCommunicator;

    public RaftClientCommunicator(Serializer serializer, ClusterMessagingService clusterCommunicator) {
        this(null, serializer, clusterCommunicator);
    }

    public RaftClientCommunicator(String prefix, Serializer serializer, ClusterMessagingService clusterCommunicator) {
        this.context = new RaftMessageContext(prefix);
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer, (Object)"serializer cannot be null");
        this.clusterCommunicator = (ClusterMessagingService)Preconditions.checkNotNull((Object)clusterCommunicator, (Object)"clusterCommunicator cannot be null");
    }

    private <T, U> CompletableFuture<U> sendAndReceive(String subject, T request, NodeId nodeId) {
        return this.clusterCommunicator.send(subject, request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), arg_0 -> ((Serializer)this.serializer).decode(arg_0), nodeId);
    }

    @Override
    public CompletableFuture<OpenSessionResponse> openSession(NodeId nodeId, OpenSessionRequest request) {
        return this.sendAndReceive(this.context.openSessionSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> closeSession(NodeId nodeId, CloseSessionRequest request) {
        return this.sendAndReceive(this.context.closeSessionSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(NodeId nodeId, KeepAliveRequest request) {
        return this.sendAndReceive(this.context.keepAliveSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<QueryResponse> query(NodeId nodeId, QueryRequest request) {
        return this.sendAndReceive(this.context.querySubject, request, nodeId);
    }

    @Override
    public CompletableFuture<CommandResponse> command(NodeId nodeId, CommandRequest request) {
        return this.sendAndReceive(this.context.commandSubject, request, nodeId);
    }

    @Override
    public CompletableFuture<MetadataResponse> metadata(NodeId nodeId, MetadataRequest request) {
        return this.sendAndReceive(this.context.metadataSubject, request, nodeId);
    }

    @Override
    public void registerHeartbeatHandler(Function<HeartbeatRequest, CompletableFuture<HeartbeatResponse>> handler) {
        this.clusterCommunicator.subscribe(this.context.heartbeatSubject, arg_0 -> ((Serializer)this.serializer).decode(arg_0), handler, arg_0 -> ((Serializer)this.serializer).encode(arg_0));
    }

    @Override
    public void unregisterHeartbeatHandler() {
        this.clusterCommunicator.unsubscribe(this.context.heartbeatSubject);
    }

    @Override
    public void reset(Set<NodeId> members, ResetRequest request) {
        this.clusterCommunicator.multicast(this.context.resetSubject(request.session()), (Object)request, arg_0 -> ((Serializer)this.serializer).encode(arg_0), members);
    }

    @Override
    public void registerPublishListener(SessionId sessionId, Consumer<PublishRequest> listener, Executor executor) {
        this.clusterCommunicator.subscribe(this.context.publishSubject((Long)sessionId.id()), arg_0 -> ((Serializer)this.serializer).decode(arg_0), listener, executor);
    }

    @Override
    public void unregisterPublishListener(SessionId sessionId) {
        this.clusterCommunicator.unsubscribe(this.context.publishSubject((Long)sessionId.id()));
    }
}

