/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.raft.RaftProtocolConfig;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RaftProtocol
implements PrimitiveProtocol {
    public static final PrimitiveProtocol.Type TYPE = new PrimitiveProtocol.Type(){

        public String name() {
            return "raft";
        }
    };
    private final RaftProtocolConfig config;

    public static Builder builder() {
        return new Builder(new RaftProtocolConfig());
    }

    public static Builder builder(String group) {
        return new Builder((RaftProtocolConfig)new RaftProtocolConfig().setGroup(group));
    }

    protected RaftProtocol(RaftProtocolConfig config) {
        this.config = (RaftProtocolConfig)((Object)Preconditions.checkNotNull((Object)((Object)config), (Object)"config cannot be null"));
    }

    public PrimitiveProtocol.Type type() {
        return TYPE;
    }

    public String group() {
        return this.config.getGroup();
    }

    public Duration minTimeout() {
        return this.config.getMinTimeout();
    }

    public Duration maxTimeout() {
        return this.config.getMaxTimeout();
    }

    public ReadConsistency readConsistency() {
        return this.config.getReadConsistency();
    }

    public CommunicationStrategy communicationStrategy() {
        return this.config.getCommunicationStrategy();
    }

    public Recovery recoveryStrategy() {
        return this.config.getRecoveryStrategy();
    }

    public int maxRetries() {
        return this.config.getMaxRetries();
    }

    public Duration retryDelay() {
        return this.config.getRetryDelay();
    }

    public Executor executor() {
        return this.config.getExecutor();
    }

    public static class Builder
    extends PrimitiveProtocol.Builder<RaftProtocolConfig, RaftProtocol> {
        protected Builder(RaftProtocolConfig config) {
            super((PrimitiveProtocolConfig)config);
        }

        public Builder withMinTimeout(Duration minTimeout) {
            ((RaftProtocolConfig)this.config).setMinTimeout(minTimeout);
            return this;
        }

        public Builder withMaxTimeout(Duration maxTimeout) {
            ((RaftProtocolConfig)this.config).setMaxTimeout(maxTimeout);
            return this;
        }

        public Builder withReadConsistency(ReadConsistency readConsistency) {
            ((RaftProtocolConfig)this.config).setReadConsistency(readConsistency);
            return this;
        }

        public Builder withCommunicationStrategy(CommunicationStrategy communicationStrategy) {
            ((RaftProtocolConfig)this.config).setCommunicationStrategy(communicationStrategy);
            return this;
        }

        public Builder withRecoveryStrategy(Recovery recoveryStrategy) {
            ((RaftProtocolConfig)this.config).setRecoveryStrategy(recoveryStrategy);
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            ((RaftProtocolConfig)this.config).setMaxRetries(maxRetries);
            return this;
        }

        public Builder withRetryDelayMillis(long retryDelayMillis) {
            return this.withRetryDelay(Duration.ofMillis(retryDelayMillis));
        }

        public Builder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
            return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
        }

        public Builder withRetryDelay(Duration retryDelay) {
            ((RaftProtocolConfig)this.config).setRetryDelay(retryDelay);
            return this;
        }

        public Builder withExecutor(Executor executor) {
            ((RaftProtocolConfig)this.config).setExecutor(executor);
            return this;
        }

        public RaftProtocol build() {
            return new RaftProtocol((RaftProtocolConfig)this.config);
        }
    }
}

