/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft;

import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveClient;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.RaftProtocol;
import io.atomix.protocols.raft.impl.DefaultRaftClient;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.utils.concurrent.ThreadModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public interface RaftClient
extends PrimitiveClient<RaftProtocol> {
    public static Builder builder() {
        return RaftClient.builder(Collections.EMPTY_LIST);
    }

    public static Builder builder(NodeId ... cluster) {
        return RaftClient.builder(Arrays.asList(cluster));
    }

    public static Builder builder(Collection<NodeId> cluster) {
        return new DefaultRaftClient.Builder(cluster);
    }

    @Deprecated
    public static Builder newBuilder() {
        return RaftClient.builder();
    }

    @Deprecated
    public static Builder newBuilder(NodeId ... cluster) {
        return RaftClient.builder(cluster);
    }

    @Deprecated
    public static Builder newBuilder(Collection<NodeId> cluster) {
        return RaftClient.builder(cluster);
    }

    public String clientId();

    public long term();

    public NodeId leader();

    public RaftMetadataClient metadata();

    default public CompletableFuture<RaftClient> connect() {
        return this.connect((Collection<NodeId>)null);
    }

    default public CompletableFuture<RaftClient> connect(NodeId ... members) {
        if (members == null || members.length == 0) {
            return this.connect();
        }
        return this.connect(Arrays.asList(members));
    }

    public CompletableFuture<RaftClient> connect(Collection<NodeId> var1);

    public CompletableFuture<Void> close();

    public static abstract class Builder
    implements io.atomix.utils.Builder<RaftClient> {
        protected final Collection<NodeId> cluster;
        protected String clientId = UUID.randomUUID().toString();
        protected NodeId nodeId;
        protected RaftClientProtocol protocol;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Runtime.getRuntime().availableProcessors();

        protected Builder(Collection<NodeId> cluster) {
            this.cluster = (Collection)Preconditions.checkNotNull(cluster, (Object)"cluster cannot be null");
        }

        public Builder withClientId(String clientId) {
            this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId cannot be null");
            return this;
        }

        public Builder withNodeId(NodeId nodeId) {
            this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId cannot be null");
            return this;
        }

        public Builder withProtocol(RaftClientProtocol protocol) {
            this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }
    }
}

