/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;

public final class SnapshotDescriptor
implements AutoCloseable {
    public static final int BYTES = 64;
    private Buffer buffer;
    private final long index;
    private final long timestamp;
    private boolean locked;

    public static Builder builder() {
        return new Builder((Buffer)HeapBuffer.allocate((int)64));
    }

    public static Builder builder(Buffer buffer) {
        return new Builder(buffer);
    }

    public SnapshotDescriptor(Buffer buffer) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        this.index = buffer.readLong();
        this.timestamp = buffer.readLong();
        this.locked = buffer.readBoolean();
        buffer.skip(64 - buffer.position());
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void lock() {
        ((Buffer)this.buffer.flush()).writeBoolean(16, true).flush();
        this.locked = true;
    }

    SnapshotDescriptor copyTo(Buffer buffer) {
        this.buffer = (Buffer)buffer.writeLong(this.index).writeLong(this.timestamp).writeBoolean(this.locked).skip(64 - buffer.position()).flush();
        return this;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        }
    }

    public static class Builder {
        private final Buffer buffer;

        private Builder(Buffer buffer) {
            this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        }

        public Builder withIndex(long index) {
            this.buffer.writeLong(0, index);
            return this;
        }

        public Builder withTimestamp(long timestamp) {
            this.buffer.writeLong(8, timestamp);
            return this;
        }

        public SnapshotDescriptor build() {
            return new SnapshotDescriptor(this.buffer);
        }
    }
}

