/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftRequest;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.proxy.impl.MemberSelector;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class RaftProxyConnection {
    private static final Predicate<RaftResponse> COMPLETE_PREDICATE = response -> response.status() == RaftResponse.Status.OK || response.error().type() == RaftError.Type.COMMAND_FAILURE || response.error().type() == RaftError.Type.QUERY_FAILURE || response.error().type() == RaftError.Type.APPLICATION_ERROR || response.error().type() == RaftError.Type.UNKNOWN_CLIENT || response.error().type() == RaftError.Type.UNKNOWN_SESSION || response.error().type() == RaftError.Type.UNKNOWN_SERVICE || response.error().type() == RaftError.Type.PROTOCOL_ERROR;
    private final Logger log;
    private final RaftClientProtocol protocol;
    private final MemberSelector selector;
    private final ThreadContext context;
    private NodeId currentNode;

    public RaftProxyConnection(RaftClientProtocol protocol, MemberSelector selector, ThreadContext context, LoggerContext loggerContext) {
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.selector = (MemberSelector)Preconditions.checkNotNull((Object)selector, (Object)"selector cannot be null");
        this.context = (ThreadContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)loggerContext);
    }

    public void reset() {
        this.selector.reset();
    }

    public void reset(NodeId leader, Collection<NodeId> servers) {
        this.selector.reset(leader, servers);
    }

    public NodeId leader() {
        return this.selector.leader();
    }

    public Collection<NodeId> members() {
        return this.selector.members();
    }

    public CompletableFuture<OpenSessionResponse> openSession(OpenSessionRequest request) {
        CompletableFuture<OpenSessionResponse> future = new CompletableFuture<OpenSessionResponse>();
        if (this.context.isCurrentContext()) {
            this.sendRequest(request, this.protocol::openSession, this.next(), future);
        } else {
            this.context.execute(() -> this.sendRequest(request, this.protocol::openSession, this.next(), future));
        }
        return future;
    }

    public CompletableFuture<CloseSessionResponse> closeSession(CloseSessionRequest request) {
        CompletableFuture<CloseSessionResponse> future = new CompletableFuture<CloseSessionResponse>();
        if (this.context.isCurrentContext()) {
            this.sendRequest(request, this.protocol::closeSession, this.next(), future);
        } else {
            this.context.execute(() -> this.sendRequest(request, this.protocol::closeSession, this.next(), future));
        }
        return future;
    }

    public CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest request) {
        CompletableFuture<KeepAliveResponse> future = new CompletableFuture<KeepAliveResponse>();
        if (this.context.isCurrentContext()) {
            this.sendRequest(request, this.protocol::keepAlive, this.next(), future);
        } else {
            this.context.execute(() -> this.sendRequest(request, this.protocol::keepAlive, this.next(), future));
        }
        return future;
    }

    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        if (this.context.isCurrentContext()) {
            this.sendRequest(request, this.protocol::query, this.next(), future);
        } else {
            this.context.execute(() -> this.sendRequest(request, this.protocol::query, this.next(), future));
        }
        return future;
    }

    public CompletableFuture<CommandResponse> command(CommandRequest request) {
        CompletableFuture<CommandResponse> future = new CompletableFuture<CommandResponse>();
        if (this.context.isCurrentContext()) {
            this.sendRequest(request, this.protocol::command, this.next(), future);
        } else {
            this.context.execute(() -> this.sendRequest(request, this.protocol::command, this.next(), future));
        }
        return future;
    }

    public CompletableFuture<MetadataResponse> metadata(MetadataRequest request) {
        CompletableFuture<MetadataResponse> future = new CompletableFuture<MetadataResponse>();
        if (this.context.isCurrentContext()) {
            this.sendRequest(request, this.protocol::metadata, this.next(), future);
        } else {
            this.context.execute(() -> this.sendRequest(request, this.protocol::metadata, this.next(), future));
        }
        return future;
    }

    protected <T extends RaftRequest, U extends RaftResponse> void sendRequest(T request, BiFunction<NodeId, T, CompletableFuture<U>> sender, NodeId member, CompletableFuture<U> future) {
        if (member != null) {
            this.log.trace("Sending {} to {}", request, (Object)member);
            sender.apply(member, (NodeId)request).whenCompleteAsync((r, e) -> {
                if (e != null || r != null) {
                    this.handleResponse(request, sender, member, (RaftResponse)r, (Throwable)e, future);
                } else {
                    future.complete(null);
                }
            }, (Executor)this.context);
        } else {
            future.completeExceptionally(new ConnectException("Failed to connect to the cluster"));
        }
    }

    protected <T extends RaftRequest> void retryRequest(Throwable cause, T request, BiFunction sender, NodeId member, CompletableFuture future) {
        if (this.currentNode == member) {
            this.log.trace("Resetting connection. Reason: {}", (Object)cause.getMessage());
            this.currentNode = null;
        }
        this.sendRequest(request, sender, this.next(), future);
    }

    protected <T extends RaftRequest> void handleResponse(T request, BiFunction sender, NodeId member, RaftResponse response, Throwable error, CompletableFuture future) {
        if (error == null) {
            this.log.trace("Received {} from {}", (Object)response, (Object)member);
            if (COMPLETE_PREDICATE.test(response)) {
                future.complete(response);
                this.selector.reset();
            } else {
                this.retryRequest((Throwable)response.error().createException(), request, sender, member, future);
            }
        } else {
            if (error instanceof CompletionException) {
                error = error.getCause();
            }
            this.log.debug("{} failed! Reason: {}", request, (Object)error);
            if (error instanceof ConnectException || error instanceof TimeoutException || error instanceof ClosedChannelException) {
                this.retryRequest(error, request, sender, member, future);
            } else {
                future.completeExceptionally(error);
            }
        }
    }

    protected NodeId next() {
        if (this.currentNode != null) {
            return this.currentNode;
        }
        if (!this.selector.hasNext()) {
            if (this.selector.leader() != null) {
                this.selector.reset(null, this.selector.members());
                this.currentNode = this.selector.next();
                return this.currentNode;
            }
            this.log.debug("Failed to connect to the cluster");
            this.selector.reset();
            return null;
        }
        this.currentNode = this.selector.next();
        return this.currentNode;
    }
}

