/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;

public final class MemberSelector
implements Iterator<NodeId>,
AutoCloseable {
    private final MemberSelectorManager selectors;
    private NodeId leader;
    private Set<NodeId> members;
    private volatile NodeId selection;
    private final CommunicationStrategy strategy;
    private Collection<NodeId> selections = new LinkedList<NodeId>();
    private Iterator<NodeId> selectionsIterator;

    public MemberSelector(NodeId leader, Collection<NodeId> members, CommunicationStrategy strategy, MemberSelectorManager selectors) {
        this.leader = leader;
        this.members = new LinkedHashSet<NodeId>(members);
        this.strategy = (CommunicationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)strategy), (Object)"strategy cannot be null"));
        this.selectors = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectors, (Object)"selectors cannot be null");
        this.selections = strategy.selectConnections(leader, Lists.newLinkedList(members));
    }

    public State state() {
        if (this.selectionsIterator == null) {
            return State.RESET;
        }
        if (this.hasNext()) {
            return State.ITERATE;
        }
        return State.COMPLETE;
    }

    public NodeId current() {
        return this.selection;
    }

    public NodeId leader() {
        return this.leader;
    }

    public Set<NodeId> members() {
        return this.members;
    }

    public MemberSelector reset() {
        if (this.selectionsIterator != null) {
            this.selections = this.strategy.selectConnections(this.leader, Lists.newLinkedList(this.members));
            this.selectionsIterator = null;
        }
        return this;
    }

    public MemberSelector reset(NodeId leader, Collection<NodeId> members) {
        if (this.changed(leader, members)) {
            this.leader = leader;
            this.members = Sets.newLinkedHashSet(members);
            this.selections = this.strategy.selectConnections(leader, Lists.newLinkedList(members));
            this.selectionsIterator = null;
        }
        return this;
    }

    private boolean changed(NodeId leader, Collection<NodeId> members) {
        Preconditions.checkNotNull(members, (Object)"members");
        Preconditions.checkArgument((!members.isEmpty() ? 1 : 0) != 0, (Object)"members cannot be empty");
        if (leader != null) {
            Preconditions.checkArgument((boolean)members.contains(leader), (Object)"leader must be present in members list");
        }
        if (!Objects.equals(this.leader, leader)) {
            return true;
        }
        return !this.matches(this.members, members);
    }

    private boolean matches(Collection<NodeId> left, Collection<NodeId> right) {
        if (left.size() != right.size()) {
            return false;
        }
        for (NodeId address : left) {
            if (right.contains(address)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.selectionsIterator == null ? !this.selections.isEmpty() : this.selectionsIterator.hasNext();
    }

    @Override
    public NodeId next() {
        NodeId selection;
        if (this.selectionsIterator == null) {
            this.selectionsIterator = this.selections.iterator();
        }
        this.selection = selection = this.selectionsIterator.next();
        return selection;
    }

    @Override
    public void close() {
        this.selectors.remove(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("strategy", (Object)this.strategy).toString();
    }

    public static enum State {
        RESET,
        ITERATE,
        COMPLETE;

    }
}

