/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public class TransferRequest
extends AbstractRaftRequest {
    protected final NodeId member;

    public static Builder builder() {
        return new Builder();
    }

    protected TransferRequest(NodeId member) {
        this.member = member;
    }

    public NodeId member() {
        return this.member;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.member);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        return ((TransferRequest)object).member.equals((Object)this.member);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("member", (Object)this.member).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, TransferRequest> {
        protected NodeId member;

        public Builder withMember(NodeId member) {
            this.member = (NodeId)Preconditions.checkNotNull((Object)member, (Object)"member cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull((Object)this.member, (Object)"member cannot be null");
        }

        public TransferRequest build() {
            return new TransferRequest(this.member);
        }
    }
}

