/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.partition.impl;

import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveClient;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftProtocol;
import io.atomix.protocols.raft.partition.RaftPartition;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.utils.Managed;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftPartitionClient
implements PrimitiveClient<RaftProtocol>,
Managed<RaftPartitionClient> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RaftPartition partition;
    private final NodeId localNodeId;
    private final RaftClientProtocol protocol;
    private RaftClient client;

    public RaftPartitionClient(RaftPartition partition, NodeId localNodeId, RaftClientProtocol protocol) {
        this.partition = partition;
        this.localNodeId = localNodeId;
        this.protocol = protocol;
    }

    public long term() {
        return this.client != null ? this.client.term() : 0L;
    }

    public NodeId leader() {
        return this.client != null ? this.client.leader() : null;
    }

    public PrimitiveProxy newProxy(String primitiveName, PrimitiveType primitiveType, RaftProtocol primitiveProtocol) {
        return this.client.newProxy(primitiveName, primitiveType, primitiveProtocol);
    }

    public CompletableFuture<Set<String>> getPrimitives(PrimitiveType primitiveType) {
        return this.client.getPrimitives(primitiveType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<RaftPartitionClient> start() {
        RaftPartitionClient raftPartitionClient = this;
        synchronized (raftPartitionClient) {
            this.client = this.newRaftClient(this.protocol);
        }
        return ((CompletableFuture)this.client.connect(this.partition.members()).whenComplete((r, e) -> {
            if (e == null) {
                this.log.info("Successfully started client for partition {}", (Object)this.partition.id());
            } else {
                this.log.info("Failed to start client for partition {}", (Object)this.partition.id(), e);
            }
        })).thenApply(v -> null);
    }

    public CompletableFuture<Void> stop() {
        return this.client != null ? this.client.close() : CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.client != null;
    }

    private RaftClient newRaftClient(RaftClientProtocol protocol) {
        return (RaftClient)RaftClient.builder().withClientId(this.partition.name()).withNodeId(this.localNodeId).withProtocol(protocol).build();
    }
}

