/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service.impl;

import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessionListener;
import io.atomix.protocols.raft.session.RaftSessions;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.session.impl.RaftSessionRegistry;
import java.util.Collection;
import java.util.Iterator;

class DefaultServiceSessions
implements RaftSessions {
    private final ServiceId serviceId;
    private final RaftSessionRegistry sessionManager;

    public DefaultServiceSessions(ServiceId serviceId, RaftSessionRegistry sessionManager) {
        this.serviceId = serviceId;
        this.sessionManager = sessionManager;
    }

    void openSession(RaftSessionContext session) {
        this.sessionManager.registerSession(session);
    }

    void expireSession(RaftSessionContext session) {
        this.sessionManager.expireSession(session.sessionId());
    }

    void closeSession(RaftSessionContext session) {
        this.sessionManager.closeSession(session.sessionId());
    }

    Collection<RaftSessionContext> getSessions() {
        return this.sessionManager.getSessions(this.serviceId);
    }

    @Override
    public RaftSession getSession(long sessionId) {
        return this.sessionManager.getSession(sessionId);
    }

    @Override
    public RaftSessions addListener(RaftSessionListener listener) {
        this.sessionManager.addListener(this.serviceId, listener);
        return this;
    }

    @Override
    public RaftSessions removeListener(RaftSessionListener listener) {
        this.sessionManager.removeListener(this.serviceId, listener);
        return this;
    }

    @Override
    public Iterator<RaftSession> iterator() {
        return this.getSessions().iterator();
    }
}

