/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.OperationRequest;
import io.atomix.protocols.raft.protocol.OperationResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.impl.RaftProxyConnection;
import io.atomix.protocols.raft.proxy.impl.RaftProxyManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxySequencer;
import io.atomix.protocols.raft.proxy.impl.RaftProxyState;
import io.atomix.utils.concurrent.ThreadContext;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

final class RaftProxyInvoker {
    private static final int[] FIBONACCI = new int[]{1, 1, 2, 3, 5};
    private static final Predicate<Throwable> EXCEPTION_PREDICATE = e -> e instanceof RaftException.ProtocolException || e instanceof ConnectException || e instanceof TimeoutException || e instanceof ClosedChannelException;
    private static final Predicate<Throwable> CLOSED_PREDICATE = e -> e instanceof RaftException.ClosedSession || e instanceof RaftException.UnknownSession;
    private final RaftProxyConnection leaderConnection;
    private final RaftProxyConnection sessionConnection;
    private final RaftProxyState state;
    private final RaftProxySequencer sequencer;
    private final RaftProxyManager manager;
    private final ThreadContext context;
    private final Map<Long, OperationAttempt> attempts = new LinkedHashMap<Long, OperationAttempt>();
    private final AtomicLong keepAliveIndex = new AtomicLong();

    public RaftProxyInvoker(RaftProxyConnection leaderConnection, RaftProxyConnection sessionConnection, RaftProxyState state, RaftProxySequencer sequencer, RaftProxyManager manager, ThreadContext context) {
        this.leaderConnection = (RaftProxyConnection)Preconditions.checkNotNull((Object)leaderConnection, (Object)"leaderConnection");
        this.sessionConnection = (RaftProxyConnection)Preconditions.checkNotNull((Object)sessionConnection, (Object)"sessionConnection");
        this.state = (RaftProxyState)Preconditions.checkNotNull((Object)state, (Object)"state");
        this.sequencer = (RaftProxySequencer)Preconditions.checkNotNull((Object)sequencer, (Object)"sequencer");
        this.manager = (RaftProxyManager)Preconditions.checkNotNull((Object)manager, (Object)"manager");
        this.context = (ThreadContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
    }

    public CompletableFuture<byte[]> invoke(RaftOperation operation) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        switch (operation.id().type()) {
            case COMMAND: {
                this.context.execute(() -> this.invokeCommand(operation, future));
                break;
            }
            case QUERY: {
                this.context.execute(() -> this.invokeQuery(operation, future));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation type " + (Object)((Object)operation.id().type()));
            }
        }
        return future;
    }

    private void invokeCommand(RaftOperation operation, CompletableFuture<byte[]> future) {
        CommandRequest request = ((CommandRequest.Builder)((CommandRequest.Builder)((CommandRequest.Builder)CommandRequest.newBuilder().withSession((Long)this.state.getSessionId().id())).withSequence(this.state.nextCommandRequest())).withOperation(operation)).build();
        this.invokeCommand(request, future);
    }

    private void invokeCommand(CommandRequest request, CompletableFuture<byte[]> future) {
        this.invoke(new CommandAttempt(this.sequencer.nextRequest(), request, future));
    }

    private void invokeQuery(RaftOperation operation, CompletableFuture<byte[]> future) {
        QueryRequest request = ((QueryRequest.Builder)((QueryRequest.Builder)((QueryRequest.Builder)QueryRequest.newBuilder().withSession((Long)this.state.getSessionId().id())).withSequence(this.state.getCommandRequest())).withOperation(operation)).withIndex(this.state.getResponseIndex()).build();
        this.invokeQuery(request, future);
    }

    private void invokeQuery(QueryRequest request, CompletableFuture<byte[]> future) {
        this.invoke(new QueryAttempt(this.sequencer.nextRequest(), request, future));
    }

    private <T extends OperationRequest, U extends OperationResponse> void invoke(OperationAttempt<T, U> attempt) {
        if (this.state.getState() == RaftProxy.State.CLOSED) {
            attempt.fail(new RaftException.ClosedSession("session closed", new Object[0]));
        } else {
            this.attempts.put(attempt.sequence, attempt);
            attempt.send();
            attempt.future.whenComplete((r, e) -> this.attempts.remove(attempt.sequence));
        }
    }

    private void resubmit(long commandSequence, OperationAttempt<?, ?> attempt) {
        long responseSequence = this.state.getCommandResponse();
        if (commandSequence < responseSequence && this.keepAliveIndex.get() != responseSequence) {
            this.keepAliveIndex.set(responseSequence);
            this.manager.resetIndexes(this.state.getSessionId()).whenCompleteAsync((result, error) -> {
                if (error == null) {
                    this.resubmit(responseSequence, attempt);
                } else {
                    this.keepAliveIndex.set(0L);
                    attempt.retry(Duration.ofSeconds(FIBONACCI[Math.min(attempt.attempt - 1, FIBONACCI.length - 1)]));
                }
            }, (Executor)this.context);
        } else {
            for (Map.Entry<Long, OperationAttempt> entry : this.attempts.entrySet()) {
                OperationAttempt operation = entry.getValue();
                if (!(operation instanceof CommandAttempt) || ((OperationRequest)operation.request).sequenceNumber() <= commandSequence || operation.attempt > attempt.attempt) continue;
                operation.retry();
            }
        }
    }

    public CompletableFuture<Void> close() {
        for (OperationAttempt attempt : new ArrayList<OperationAttempt>(this.attempts.values())) {
            attempt.fail(new RaftException.ClosedSession("session closed", new Object[0]));
        }
        this.attempts.clear();
        return CompletableFuture.completedFuture(null);
    }

    private final class QueryAttempt
    extends OperationAttempt<QueryRequest, QueryResponse> {
        QueryAttempt(long sequence, QueryRequest request, CompletableFuture<byte[]> future) {
            super(RaftProxyInvoker.this, sequence, 1, (OperationRequest)request, future);
        }

        QueryAttempt(long sequence, int attempt, QueryRequest request, CompletableFuture<byte[]> future) {
            super(RaftProxyInvoker.this, sequence, attempt, (OperationRequest)request, future);
        }

        @Override
        protected void send() {
            RaftProxyInvoker.this.sessionConnection.query((QueryRequest)this.request).whenComplete((BiConsumer)this);
        }

        @Override
        protected OperationAttempt<QueryRequest, QueryResponse> next() {
            return new QueryAttempt(this.sequence, this.attempt + 1, (QueryRequest)this.request, this.future);
        }

        @Override
        protected Throwable defaultException() {
            return new RaftException.QueryFailure("failed to complete query", new Object[0]);
        }

        @Override
        public void accept(QueryResponse response, Throwable error) {
            if (error == null) {
                if (response.status() == RaftResponse.Status.OK) {
                    this.complete(response);
                } else if (response.error().type() == RaftError.Type.UNKNOWN_CLIENT || response.error().type() == RaftError.Type.UNKNOWN_SESSION || response.error().type() == RaftError.Type.UNKNOWN_SERVICE || response.error().type() == RaftError.Type.CLOSED_SESSION) {
                    RaftProxyInvoker.this.state.setState(RaftProxy.State.CLOSED);
                    this.complete(response.error().createException());
                } else {
                    this.complete(response.error().createException());
                }
            } else {
                this.fail(error);
            }
        }

        @Override
        protected void complete(QueryResponse response) {
            this.sequence(response, () -> {
                RaftProxyInvoker.this.state.setResponseIndex(response.index());
                this.future.complete(response.result());
            });
        }
    }

    private final class CommandAttempt
    extends OperationAttempt<CommandRequest, CommandResponse> {
        CommandAttempt(long sequence, CommandRequest request, CompletableFuture<byte[]> future) {
            super(RaftProxyInvoker.this, sequence, 1, (OperationRequest)request, future);
        }

        CommandAttempt(long sequence, int attempt, CommandRequest request, CompletableFuture<byte[]> future) {
            super(RaftProxyInvoker.this, sequence, attempt, (OperationRequest)request, future);
        }

        @Override
        protected void send() {
            RaftProxyInvoker.this.leaderConnection.command((CommandRequest)this.request).whenComplete((BiConsumer)this);
        }

        @Override
        protected OperationAttempt<CommandRequest, CommandResponse> next() {
            return new CommandAttempt(this.sequence, this.attempt + 1, (CommandRequest)this.request, this.future);
        }

        @Override
        protected Throwable defaultException() {
            return new RaftException.CommandFailure("failed to complete command", new Object[0]);
        }

        @Override
        public void accept(CommandResponse response, Throwable error) {
            if (error == null) {
                if (response.status() == RaftResponse.Status.OK) {
                    this.complete(response);
                } else if (response.error().type() == RaftError.Type.COMMAND_FAILURE) {
                    RaftProxyInvoker.this.resubmit(response.lastSequenceNumber(), this);
                } else if (response.error().type() == RaftError.Type.APPLICATION_ERROR) {
                    this.complete(response.error().createException());
                } else if (response.error().type() == RaftError.Type.UNKNOWN_CLIENT || response.error().type() == RaftError.Type.UNKNOWN_SESSION || response.error().type() == RaftError.Type.UNKNOWN_SERVICE || response.error().type() == RaftError.Type.CLOSED_SESSION) {
                    RaftProxyInvoker.this.state.setState(RaftProxy.State.CLOSED);
                    this.complete(response.error().createException());
                } else {
                    this.retry(Duration.ofSeconds(FIBONACCI[Math.min(this.attempt - 1, FIBONACCI.length - 1)]));
                }
            } else if (EXCEPTION_PREDICATE.test(error) || error instanceof CompletionException && EXCEPTION_PREDICATE.test(error.getCause())) {
                if (error instanceof ConnectException || error.getCause() instanceof ConnectException) {
                    RaftProxyInvoker.this.leaderConnection.reset(null, RaftProxyInvoker.this.leaderConnection.members());
                }
                this.retry(Duration.ofSeconds(FIBONACCI[Math.min(this.attempt - 1, FIBONACCI.length - 1)]));
            } else {
                this.fail(error);
            }
        }

        @Override
        protected void complete(CommandResponse response) {
            this.sequence(response, () -> {
                RaftProxyInvoker.this.state.setCommandResponse(((CommandRequest)this.request).sequenceNumber());
                RaftProxyInvoker.this.state.setResponseIndex(response.index());
                this.future.complete(response.result());
            });
        }
    }

    private abstract class OperationAttempt<T extends OperationRequest, U extends OperationResponse>
    implements BiConsumer<U, Throwable> {
        protected final long sequence;
        protected final int attempt;
        protected final T request;
        protected final CompletableFuture<byte[]> future;
        final /* synthetic */ RaftProxyInvoker this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected OperationAttempt(long attempt, int future, T t, CompletableFuture<byte[]> completableFuture) {
            void request;
            void sequence;
            this.this$0 = (RaftProxyInvoker)l;
            this.sequence = sequence;
            this.attempt = (int)attempt;
            this.request = request;
            this.future = (CompletableFuture<byte[]>)future;
        }

        protected abstract void send();

        protected abstract OperationAttempt<T, U> next();

        protected abstract Throwable defaultException();

        protected abstract void complete(U var1);

        protected void complete(Throwable error) {
            this.sequence(null, () -> this.future.completeExceptionally(error));
        }

        protected final void sequence(OperationResponse response, Runnable callback) {
            this.this$0.sequencer.sequenceResponse(this.sequence, response, callback);
        }

        public void fail() {
            this.fail(this.defaultException());
        }

        public void fail(Throwable t) {
            this.complete(t);
            if (CLOSED_PREDICATE.test(t)) {
                this.this$0.state.setState(RaftProxy.State.CLOSED);
            }
        }

        public void retry() {
            this.this$0.context.execute(() -> this.this$0.invoke(this.next()));
        }

        public void retry(Duration after) {
            this.this$0.context.schedule(after, () -> this.this$0.invoke(this.next()));
        }
    }
}

