/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.service.RaftService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class RaftServiceFactoryRegistry {
    private final Map<String, Supplier<RaftService>> stateMachines = new ConcurrentHashMap<String, Supplier<RaftService>>();

    public int size() {
        return this.stateMachines.size();
    }

    public RaftServiceFactoryRegistry register(String type, Supplier<RaftService> factory) {
        this.stateMachines.put((String)Preconditions.checkNotNull((Object)type, (Object)"type cannot be null"), (Supplier<RaftService>)Preconditions.checkNotNull(factory, (Object)"factory cannot be null"));
        return this;
    }

    public RaftServiceFactoryRegistry unregister(String type) {
        this.stateMachines.remove(type);
        return this;
    }

    public Supplier<RaftService> getFactory(String type) {
        return this.stateMachines.get(type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stateMachines", this.stateMachines).toString();
    }
}

