/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.impl.MemberSelector;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class MemberSelectorManager {
    private final Set<MemberSelector> selectors = new CopyOnWriteArraySet<MemberSelector>();
    private volatile MemberId leader;
    private volatile Collection<MemberId> members = Collections.emptyList();

    public MemberId leader() {
        return this.leader;
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public MemberSelector createSelector(CommunicationStrategy selectionStrategy) {
        MemberSelector selector = new MemberSelector(this.leader, this.members, selectionStrategy, this);
        this.selectors.add(selector);
        return selector;
    }

    public void resetAll() {
        this.selectors.forEach(MemberSelector::reset);
    }

    public void resetAll(MemberId leader, Collection<MemberId> members) {
        this.leader = leader;
        this.members = new LinkedList<MemberId>(members);
        this.selectors.forEach(s -> s.reset(leader, members));
    }

    void remove(MemberSelector selector) {
        this.selectors.remove(selector);
    }
}

