/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.RaftRequest;
import io.atomix.protocols.raft.roles.AbstractAppender;
import io.atomix.protocols.raft.roles.LeaderRole;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

final class LeaderAppender
extends AbstractAppender {
    private static final long MAX_HEARTBEAT_WAIT = 60000L;
    private static final int MIN_BACKOFF_FAILURE_COUNT = 5;
    private static final int MIN_STEP_DOWN_FAILURE_COUNT = 3;
    private final long leaderTime;
    private final long leaderIndex;
    private final long electionTimeout;
    private final long heartbeatInterval;
    private long heartbeatTime;
    private final Map<Long, CompletableFuture<Long>> appendFutures = new HashMap<Long, CompletableFuture<Long>>();
    private final List<TimestampedFuture<Long>> heartbeatFutures = new ArrayList<TimestampedFuture<Long>>();

    LeaderAppender(LeaderRole leader) {
        super(leader.raft);
        this.leaderTime = System.currentTimeMillis();
        this.leaderIndex = this.raft.getLogWriter().getNextIndex();
        this.heartbeatTime = this.leaderTime;
        this.electionTimeout = this.raft.getElectionTimeout().toMillis();
        this.heartbeatInterval = this.raft.getHeartbeatInterval().toMillis();
    }

    public long getTime() {
        return this.heartbeatTime;
    }

    public long getIndex() {
        return this.leaderIndex;
    }

    private int getQuorumIndex() {
        return this.raft.getCluster().getQuorum() - 2;
    }

    public CompletableFuture<Long> appendEntries() {
        this.raft.checkThread();
        if (this.raft.getCluster().getRemoteMemberStates().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        TimestampedFuture<Long> future = new TimestampedFuture<Long>();
        this.heartbeatFutures.add(future);
        for (RaftMemberContext member : this.raft.getCluster().getRemoteMemberStates()) {
            this.appendEntries(member);
        }
        return future;
    }

    public CompletableFuture<Long> appendEntries(long index) {
        this.raft.checkThread();
        if (index == 0L) {
            return this.appendEntries();
        }
        if (index <= this.raft.getCommitIndex()) {
            return CompletableFuture.completedFuture(index);
        }
        if (this.raft.getCluster().getActiveMemberStates().isEmpty() && this.raft.getCluster().getPassiveMemberStates().isEmpty()) {
            long previousCommitIndex = this.raft.getCommitIndex();
            this.raft.setCommitIndex(index);
            this.completeCommits(previousCommitIndex, index);
            return CompletableFuture.completedFuture(index);
        }
        if (this.raft.getCluster().getActiveMemberStates().isEmpty()) {
            long previousCommitIndex = this.raft.getCommitIndex();
            this.raft.setCommitIndex(index);
            this.completeCommits(previousCommitIndex, index);
            return CompletableFuture.completedFuture(index);
        }
        return this.appendFutures.computeIfAbsent(index, i -> {
            for (RaftMemberContext member : this.raft.getCluster().getActiveMemberStates()) {
                this.appendEntries(member);
            }
            return new CompletableFuture();
        });
    }

    @Override
    protected void appendEntries(RaftMemberContext member) {
        if (!this.open) {
            return;
        }
        if (member.getFailureCount() >= 5) {
            if ((double)(System.currentTimeMillis() - member.getFailureTime()) > Math.min((double)this.heartbeatInterval * Math.pow(2.0, member.getFailureCount()), 60000.0)) {
                this.sendAppendRequest(member, this.buildAppendEmptyRequest(member));
            }
        } else if (member.getConfigTerm() < this.raft.getTerm() || member.getConfigIndex() < this.raft.getCluster().getConfiguration().index()) {
            if (member.canConfigure()) {
                this.sendConfigureRequest(member, this.buildConfigureRequest(member));
            } else if (member.canHeartbeat()) {
                this.sendAppendRequest(member, this.buildAppendEmptyRequest(member));
            }
        } else if (member.getMember().getType() == RaftMember.Type.ACTIVE || member.getMember().getType() == RaftMember.Type.PROMOTABLE || member.getMember().getType() == RaftMember.Type.PASSIVE) {
            Snapshot snapshot = this.raft.getSnapshotStore().getCurrentSnapshot();
            if (snapshot != null && member.getSnapshotIndex() < snapshot.index() && snapshot.index() >= member.getLogReader().getCurrentIndex()) {
                if (!member.canInstall()) {
                    return;
                }
                this.log.debug("Replicating snapshot {} to {}", (Object)snapshot.index(), (Object)member.getMember().memberId());
                this.sendInstallRequest(member, this.buildInstallRequest(member, snapshot));
            } else if (member.canAppend()) {
                this.sendAppendRequest(member, this.buildAppendRequest(member, -1L));
            }
        } else if (member.canAppend()) {
            this.sendAppendRequest(member, this.buildAppendRequest(member, -1L));
        }
    }

    @Override
    protected boolean hasMoreEntries(RaftMemberContext member) {
        return member.getLogReader().hasNext();
    }

    private long computeHeartbeatTime() {
        int quorumIndex = this.getQuorumIndex();
        if (quorumIndex >= 0) {
            return this.raft.getCluster().getActiveMemberStates((m1, m2) -> Long.compare(m2.getHeartbeatTime(), m1.getHeartbeatTime())).get(quorumIndex).getHeartbeatTime();
        }
        return System.currentTimeMillis();
    }

    private long computeResponseTime() {
        int quorumIndex = this.getQuorumIndex();
        if (quorumIndex >= 0) {
            return this.raft.getCluster().getActiveMemberStates((m1, m2) -> Long.compare(m2.getResponseTime(), m1.getResponseTime())).get(quorumIndex).getResponseTime();
        }
        return System.currentTimeMillis();
    }

    private void recordHeartbeat(RaftMemberContext member, long timestamp) {
        this.raft.checkThread();
        member.setHeartbeatTime(timestamp);
        member.setResponseTime(System.currentTimeMillis());
        long heartbeatTime = this.computeHeartbeatTime();
        long currentTimestamp = System.currentTimeMillis();
        Iterator<TimestampedFuture<Long>> iterator = this.heartbeatFutures.iterator();
        while (iterator.hasNext()) {
            TimestampedFuture<Long> future = iterator.next();
            if (((TimestampedFuture)future).timestamp < heartbeatTime) {
                future.complete(null);
                iterator.remove();
                continue;
            }
            if (currentTimestamp - ((TimestampedFuture)future).timestamp <= this.electionTimeout) break;
            future.completeExceptionally(new RaftException.ProtocolException("Failed to reach consensus", new Object[0]));
            iterator.remove();
        }
        if (!this.heartbeatFutures.isEmpty()) {
            this.sendHeartbeats();
        }
    }

    private void failHeartbeat() {
        this.raft.checkThread();
        long currentTimestamp = System.currentTimeMillis();
        Iterator<TimestampedFuture<Long>> iterator = this.heartbeatFutures.iterator();
        while (iterator.hasNext()) {
            TimestampedFuture<Long> future = iterator.next();
            if (currentTimestamp - ((TimestampedFuture)future).timestamp <= this.electionTimeout) continue;
            future.completeExceptionally(new RaftException.ProtocolException("Failed to reach consensus", new Object[0]));
            iterator.remove();
        }
    }

    private void sendHeartbeats() {
        for (RaftMemberContext member : this.raft.getCluster().getRemoteMemberStates()) {
            this.appendEntries(member);
        }
    }

    private void commitEntries() {
        this.raft.checkThread();
        List<RaftMemberContext> members = this.raft.getCluster().getActiveMemberStates((m1, m2) -> Long.compare(m2.getMatchIndex() != 0L ? m2.getMatchIndex() : 0L, m1.getMatchIndex() != 0L ? m1.getMatchIndex() : 0L));
        if (members.isEmpty()) {
            long previousCommitIndex;
            long commitIndex = this.raft.getLogWriter().getLastIndex();
            if (commitIndex > (previousCommitIndex = this.raft.setCommitIndex(commitIndex))) {
                this.log.trace("Committed entries up to {}", (Object)commitIndex);
                this.completeCommits(previousCommitIndex, commitIndex);
            }
            return;
        }
        long commitIndex = members.get(this.getQuorumIndex()).getMatchIndex();
        long previousCommitIndex = this.raft.getCommitIndex();
        if (commitIndex > 0L && commitIndex > previousCommitIndex && this.leaderIndex > 0L && commitIndex >= this.leaderIndex) {
            this.log.trace("Committed entries up to {}", (Object)commitIndex);
            this.raft.setCommitIndex(commitIndex);
            this.completeCommits(previousCommitIndex, commitIndex);
        }
    }

    private void completeCommits(long previousCommitIndex, long commitIndex) {
        for (long i = previousCommitIndex + 1L; i <= commitIndex; ++i) {
            CompletableFuture<Long> future = this.appendFutures.remove(i);
            if (future == null) continue;
            future.complete(i);
        }
    }

    @Override
    protected void handleAppendResponseFailure(RaftMemberContext member, AppendRequest request, Throwable error) {
        this.failHeartbeat();
        super.handleAppendResponseFailure(member, request, error);
    }

    @Override
    protected void handleAppendResponse(RaftMemberContext member, AppendRequest request, AppendResponse response, long timestamp) {
        super.handleAppendResponse(member, request, response, timestamp);
        this.recordHeartbeat(member, timestamp);
    }

    @Override
    protected void handleAppendResponseOk(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        this.succeedAttempt(member);
        if (response.succeeded()) {
            member.appendSucceeded();
            this.updateMatchIndex(member, response);
            if (!request.entries().isEmpty()) {
                this.commitEntries();
            }
            if (this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        } else if (response.term() > this.raft.getTerm()) {
            this.raft.setTerm(response.term());
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        } else {
            member.appendFailed();
            this.resetSnapshotIndex(member, response);
            this.resetMatchIndex(member, response);
            this.resetNextIndex(member, response);
            if (this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        }
    }

    @Override
    protected void handleAppendResponseError(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        if (response.term() > this.raft.getTerm()) {
            this.log.debug("Received higher term from {}", (Object)member.getMember().memberId());
            this.raft.setTerm(response.term());
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        } else {
            super.handleAppendResponseError(member, request, response);
        }
    }

    @Override
    protected void failAttempt(RaftMemberContext member, RaftRequest request, Throwable error) {
        super.failAttempt(member, request, error);
        this.failHeartbeat();
        if (member.getFailureCount() >= 3 && System.currentTimeMillis() - Math.max(this.computeResponseTime(), this.leaderTime) > this.electionTimeout * 2L) {
            this.log.warn("Suspected network partition. Stepping down");
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        }
    }

    @Override
    protected void handleConfigureResponse(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response, long timestamp) {
        super.handleConfigureResponse(member, request, response, timestamp);
        this.recordHeartbeat(member, timestamp);
    }

    @Override
    protected void handleInstallResponse(RaftMemberContext member, InstallRequest request, InstallResponse response, long timestamp) {
        super.handleInstallResponse(member, request, response, timestamp);
        this.recordHeartbeat(member, timestamp);
    }

    @Override
    public void close() {
        super.close();
        this.appendFutures.values().forEach(future -> future.completeExceptionally(new IllegalStateException("Inactive state")));
        this.heartbeatFutures.forEach(future -> future.completeExceptionally(new RaftException.ProtocolException("Failed to reach consensus", new Object[0])));
    }

    private static class TimestampedFuture<T>
    extends CompletableFuture<T> {
        private final long timestamp;

        public TimestampedFuture() {
            this(System.currentTimeMillis());
        }

        public TimestampedFuture(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

