/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.InactiveRole;
import io.atomix.protocols.raft.roles.RaftRole;
import java.util.concurrent.CompletableFuture;

public class ReserveRole
extends InactiveRole {
    public ReserveRole(RaftContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.RESERVE;
    }

    @Override
    public CompletableFuture<RaftRole> open() {
        return ((CompletableFuture)super.open().thenRun(() -> {
            if (this.role() == RaftServer.Role.RESERVE) {
                this.raft.reset();
            }
        })).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<MetadataResponse> onMetadata(MetadataRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::metadata).exceptionally(error -> ((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        this.raft.setCommitIndex(request.commitIndex());
        return CompletableFuture.completedFuture(this.logResponse(((AppendResponse.Builder)AppendResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withSucceeded(true).withLastLogIndex(0L).build()));
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot poll RESERVE member")).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), null);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot request vote from RESERVE member")).build()));
    }

    @Override
    public CompletableFuture<CommandResponse> onCommand(CommandRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::command).exceptionally(error -> ((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::query).exceptionally(error -> ((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> onKeepAlive(KeepAliveRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::keepAlive).exceptionally(error -> ((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<OpenSessionResponse> onOpenSession(OpenSessionRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::openSession).exceptionally(error -> ((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<CloseSessionResponse> onCloseSession(CloseSessionRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::closeSession).exceptionally(error -> ((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<JoinResponse> onJoin(JoinRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::join).exceptionally(error -> ((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::reconfigure).exceptionally(error -> ((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<LeaveResponse> onLeave(LeaveRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::leave).exceptionally(error -> ((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot install snapshot to RESERVE member")).build()));
    }

    @Override
    public CompletableFuture<Void> close() {
        return super.close().thenRun(() -> {
            if (this.role() == RaftServer.Role.RESERVE) {
                this.raft.reset();
            }
        });
    }
}

