/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxyConnection;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.RaftSessionMetadata;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.logging.LoggerContext;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class DefaultRaftMetadataClient
implements RaftMetadataClient {
    private final MemberSelectorManager selectorManager;
    private final RaftProxyConnection connection;

    public DefaultRaftMetadataClient(String clientId, RaftClientProtocol protocol, MemberSelectorManager selectorManager, ThreadContext context) {
        this.selectorManager = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectorManager, (Object)"selectorManager cannot be null");
        this.connection = new RaftProxyConnection(protocol, selectorManager.createSelector(CommunicationStrategy.LEADER), context, LoggerContext.builder(RaftClient.class).addValue((Object)clientId).build());
    }

    @Override
    public MemberId getLeader() {
        return this.selectorManager.leader();
    }

    @Override
    public Collection<MemberId> getServers() {
        return this.selectorManager.servers();
    }

    private CompletableFuture<MetadataResponse> getMetadata() {
        CompletableFuture<MetadataResponse> future = new CompletableFuture<MetadataResponse>();
        this.connection.metadata(MetadataRequest.newBuilder().build()).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == RaftResponse.Status.OK) {
                    future.complete((MetadataResponse)response);
                } else {
                    future.completeExceptionally(response.error().createException());
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<Set<RaftSessionMetadata>> getSessions() {
        return this.getMetadata().thenApply(MetadataResponse::sessions);
    }

    @Override
    public CompletableFuture<Set<RaftSessionMetadata>> getSessions(ServiceType serviceType) {
        return this.getMetadata().thenApply(response -> response.sessions().stream().filter(s -> ((String)((Object)s.serviceType().id())).equals(serviceType.id())).collect(Collectors.toSet()));
    }

    @Override
    public CompletableFuture<Set<RaftSessionMetadata>> getSessions(ServiceType serviceType, String serviceName) {
        return this.getMetadata().thenApply(response -> response.sessions().stream().filter(s -> ((String)((Object)s.serviceType().id())).equals(serviceType.id()) && s.serviceName().equals(serviceName)).collect(Collectors.toSet()));
    }
}

