/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service.impl;

import com.google.common.collect.Sets;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessionListener;
import io.atomix.protocols.raft.session.RaftSessions;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.session.impl.RaftSessionRegistry;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

class DefaultServiceSessions
implements RaftSessions {
    private final ServiceId serviceId;
    private final Set<RaftSessionListener> listeners = Sets.newIdentityHashSet();
    private final RaftSessionRegistry sessionManager;

    public DefaultServiceSessions(ServiceId serviceId, RaftSessionRegistry sessionManager) {
        this.serviceId = serviceId;
        this.sessionManager = sessionManager;
    }

    RaftSessionContext addSession(RaftSessionContext session) {
        return this.sessionManager.addSession(session);
    }

    void openSession(RaftSessionContext session) {
        RaftSessionContext singletonSession = this.sessionManager.addSession(session);
        singletonSession.open();
        this.listeners.forEach(l -> l.onOpen(singletonSession));
    }

    void expireSession(RaftSessionContext session) {
        RaftSessionContext singletonSession = this.sessionManager.removeSession(session.sessionId());
        if (singletonSession != null) {
            singletonSession.expire();
            this.listeners.forEach(l -> l.onExpire(singletonSession));
        }
    }

    void closeSession(RaftSessionContext session) {
        RaftSessionContext singletonSession = this.sessionManager.removeSession(session.sessionId());
        if (singletonSession != null) {
            singletonSession.close();
            this.listeners.forEach(l -> l.onClose(singletonSession));
        }
    }

    Collection<RaftSessionContext> getSessions() {
        return this.sessionManager.getSessions(this.serviceId);
    }

    @Override
    public RaftSession getSession(long sessionId) {
        RaftSessionContext session = this.sessionManager.getSession(sessionId);
        return session != null && session.getState().active() ? session : null;
    }

    @Override
    public RaftSessions addListener(RaftSessionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public RaftSessions removeListener(RaftSessionListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public Iterator<RaftSession> iterator() {
        return this.getSessions().iterator();
    }
}

