/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.operation.OperationId;
import io.atomix.protocols.raft.service.Commit;
import io.atomix.storage.buffer.HeapBytes;
import io.atomix.time.WallClockTimestamp;
import io.atomix.utils.concurrent.Scheduler;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface RaftServiceExecutor
extends Scheduler,
Executor {
    public void tick(WallClockTimestamp var1);

    public byte[] apply(Commit<byte[]> var1);

    public void handle(OperationId var1, Function<Commit<byte[]>, byte[]> var2);

    default public void register(OperationId operationId, Runnable callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull((Object)callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> {
            callback.run();
            return HeapBytes.EMPTY;
        });
    }

    default public <R> void register(OperationId operationId, Supplier<R> callback, Function<R, byte[]> encoder) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> (byte[])encoder.apply(callback.get()));
    }

    default public void register(OperationId operationId, Consumer<Commit<Void>> callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> {
            callback.accept(commit.mapToNull());
            return HeapBytes.EMPTY;
        });
    }

    default public <R> void register(OperationId operationId, Function<Commit<Void>, R> callback, Function<R, byte[]> encoder) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        Preconditions.checkNotNull(encoder, (Object)"encoder cannot be null");
        this.handle(operationId, commit -> (byte[])encoder.apply(callback.apply(commit.mapToNull())));
    }

    default public <T> void register(OperationId operationId, Function<byte[], T> decoder, Consumer<Commit<T>> callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(decoder, (Object)"decoder cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> {
            callback.accept(commit.map(decoder));
            return HeapBytes.EMPTY;
        });
    }

    default public <T, R> void register(OperationId operationId, Function<byte[], T> decoder, Function<Commit<T>, R> callback, Function<R, byte[]> encoder) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(decoder, (Object)"decoder cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        Preconditions.checkNotNull(encoder, (Object)"encoder cannot be null");
        this.handle(operationId, commit -> (byte[])encoder.apply(callback.apply(commit.map(decoder))));
    }
}

